theory question_47_2
imports Main

begin

typedecl entity
typedecl event

consts
  Grill :: "entity ⇒ bool"
  FoodOn :: "entity ⇒ entity ⇒ bool"
  Woman :: "entity ⇒ bool"
  Dress :: "entity ⇒ bool"
  Blue :: "entity ⇒ bool"
  StarPrinted :: "entity ⇒ bool"
  Cooking :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Near :: "entity ⇒ entity ⇒ bool"
  StarryDress :: "entity ⇒ bool"

(* Explanation: If there is a grill with food on it, then it is cooking. *)
axiomatization where
  explanation: "∀x e. Grill x ∧ FoodOn x e ⟶ Cooking e"

theorem hypothesis:
  (* Premise: A woman in a blue star printed dress stands next to a grill with food on it. *)
  assumes asm: "Woman x ∧ Dress y ∧ Blue y ∧ StarPrinted y ∧ Grill z ∧ FoodOn z e ∧ Near x z"
  (* Hypothesis: A woman in a starry dress is near a grill that is cooking. *)
  shows "∃x y z e. Woman x ∧ StarryDress y ∧ Grill z ∧ Cooking e ∧ Agent e z ∧ Near x z"
proof -
  from asm have "Grill z ∧ FoodOn z e" by blast
  with explanation show "Cooking e" by blast
  then have "∃z e. Grill z ∧ Cooking e ∧ Agent e z" by (rule exI[of _ "z" "e"] conjI)
  moreover have "Woman x ∧ Dress y ∧ Blue y ∧ StarPrinted y ∧ Near x z" using asm by blast
  ultimately have "∃x y z e. Woman x ∧ StarryDress y ∧ Grill z ∧ Cooking e ∧ Agent e z ∧ Near x z"
    using StarryDress_def Near_def by (rule exI[of _ "x" "y" "z" "e"] conjI)
  then show ?thesis by blast
qed

end
