theory question_65_2

imports Main

begin

typedecl entity
typedecl event

consts
  ElectricityFlows :: "entity ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  On :: "entity ⇒ bool"
  ComesOn :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: When electricity flows to a light bulb, the light comes on. *)
axiomatization where
  explanation_1: "∀x y z e. ElectricityFlows x ∧ LightBulb y ∧ On z ⟶ ComesOn e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: When a switch in a simple series circuit is closed, electricity flows through the circuit. *)
axiomatization where
  explanation_2: "∀x y z e. SwitchClosed x ∧ SimpleSeriesCircuit y ∧ ElectricityFlows z ⟶ FlowsThrough e ∧ Agent e x ∧ Patient e y"

(* Premise: When the switch in a simple series circuit is closed. *)
assumes asm: "SwitchClosed x ∧ SimpleSeriesCircuit y ∧ Closes e ∧ Agent e x ∧ Patient e y"

(* Hypothesis: When electricity flows to a light bulb, the light comes on. *)
shows "∃e. ComesOn e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "SwitchClosed x ∧ SimpleSeriesCircuit y ∧ Closes e ∧ Agent e x ∧ Patient e y" by simp
  then obtain e1 where e1: "FlowsThrough e1 ∧ Agent e1 x ∧ Patient e1 y" using explanation_2 by blast
  then have "ElectricityFlows z" using e1 by simp
  then have "ComesOn e2 ∧ Agent e2 x ∧ Patient e2 y" using explanation_1 by blast
  show ?thesis using asm e1 e2 by blast
qed

end
