theory question_91_5

imports Main

begin

typedecl entity
typedecl event

consts
 Child :: "entity ⇒ bool"
 Outside :: "entity ⇒ bool"
 Playing :: "event ⇒ bool"
 Agent :: "event ⇒ entity ⇒ bool"
 In :: "event ⇒ entity ⇒ bool"
 Street :: "entity ⇒ bool"
 Walking :: "event ⇒ bool"
 Down :: "event ⇒ entity ⇒ bool"
 Has :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Children playing outside are playing. *)
axiomatization where
 explanation_1: "∀x y e. Child x ∧ Outside y ∧ Playing e ∧ Agent e x ∧ In e y"

(* Explanation 2: People walking down a street means that the street has those people. *)
axiomatization where
 explanation_2: "∀x y e. Street x ∧ Walking e ∧ Agent e y ∧ Down e x ⟶ Has x y"

theorem hypothesis:
 (* Premise: Several children playing outside. *)
 assumes asm: "Child x  ∧ Outside y  ∧ Playing e  ∧ Agent e  x  ∧ In e  y  ∧ Plural z "
 (* Hypothesis: There are children playing. *)
 shows "∃x e. Child x  ∧ Playing e  ∧ Agent e  x "
proof -
 from asm have "Child x" by blast
 then have "Playing e" using explanation_1 by blast
 then show ?thesis using `Child x` `Playing e` by blast
qed

end
