theory question_7_0

imports Main

begin

typedecl entity
typedecl event
consts
  Girl :: "entity ⇒ bool"
  Jumping :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  YellowRope :: "entity ⇒ bool"
  JumpingOverYellowRope :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: jumping over a yellow rope is same as jumps rope. *)
axiomatization where
  explanation_1: "∀x y e. JumpingOverYellowRope x y ⟶ JumpsRope e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  (* Premise: A little girl is jumping over a yellow rope. *)
  assumes asm: "LittleGirl x  ∧ YellowRope y  ∧ JumpingOver e  ∧ Agent e  x  ∧ Patient e  y  ∧ InFrontOf x  y "
  (* Hypothesis: A girl jumps rope. *)
  shows "∃x e. Girl x  ∧ Jumping e  ∧ Agent e  x "
proof -
  from asm have "LittleGirl x" by blast
  from this have "Girl x" using explanation_1 by blast
  from asm have "JumpingOver e" by blast
  from this have "Jumping e" using explanation_1 by blast
  show ?thesis using `Girl x` `Jumping e` by blast
qed

end
