theory question_54_5

imports Main

begin

typedecl entity
typedecl event
consts
  Man :: "entity ⇒ bool"
  Tennis :: "event ⇒ bool"
  Striking :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  AboutTo :: "event ⇒ entity ⇒ bool"
  Playing :: "event ⇒ bool"

(* Explanation 1: A man playing tennis is about to strike a tennis ball. *)
axiomatization where
  explanation_1: "∃x e. Man x ∧ Tennis e ∧ Striking e ∧ Agent e x ∧ AboutTo e x"

(* Explanation 2: The man is playing tennis. *)
axiomatization where
  explanation_2: "∃x e. Man x ∧ Tennis e ∧ Playing e ∧ Agent e x"

theorem hypothesis:
  (* Premise: A man in red and black about to strike a tennis ball. *)
  assumes asm: "Man x ∧ RedAndBlack x ∧ TennisBall e ∧ Striking e ∧ Agent e x ∧ AboutTo e x"
  (* Hypothesis: A man is playing tennis. *)
  shows "∃x e. Man x ∧ Tennis e ∧ Playing e ∧ Agent e x"
proof -
  from asm have "Man x" by blast
  from this have "Tennis e" using explanation_1 by blast
  from asm have "Striking e" by blast
  from this have "Playing e" using explanation_2 by blast
  show ?thesis using `Man x` `Tennis e` `Playing e` by blast
qed

end
