theory question_70_0
imports Main

begin
typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  Woman :: "entity ⇒ bool"
  TwoPeople :: "entity ⇒ entity ⇒ bool"
  Looking :: "event ⇒ bool"
  Stare :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Skyline :: "entity ⇒ bool"
  Outside :: "event ⇒ bool"

(* Explanation 1: A man and a woman are two people. "Looking outside" is a rephrasing of "stare at the skyline." *)
axiomatization where
  explanation_1: "∀x y. (Man x ∧ Woman y ⟶ TwoPeople x y) ∧ ∀e. (Looking e ⟷ Stare e)"

theorem hypothesis:
  (* Premise: A man and a woman stare at the skyline. *)
  assumes asm: "Man x ∧ Woman y ∧ Skyline z ∧ Stare e ∧ Agent e x ∧ Agent e y ∧ Patient e z"
  (* Hypothesis: The two people are looking outside. *)
  shows "∃x e. TwoPeople x ∧ Looking e ∧ Agent e x ∧ Outside e"
proof -
  from asm have "Man x ∧ Woman y ∧ Stare e ∧ Agent e x ∧ Agent e y" by blast
  then have "TwoPeople x ∧ Looking e ∧ Agent e x" using explanation_1 by blast
  from asm have "Skyline z ∧ Patient e z" by blast
  then have "Outside e" using explanation_1 by blast
  show ?thesis using `TwoPeople x` `Looking e` `Agent e x` `Outside e` by blast
qed

end
