theory question_99_0
imports Main
begin

typedecl entity
typedecl event

consts
  VegetableOil :: "entity ⇒ bool"
  RenewableResource :: "entity ⇒ bool"
  Fuel :: "entity ⇒ bool"
  Is :: "entity ⇒ entity ⇒ bool"
  OrganicallyProduced :: "entity ⇒ bool"
  DieselEngine :: "entity ⇒ bool"
  IsMostRenewableFuel :: "entity ⇒ bool"
  CanBurn :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: vegetable oil is a renewable resource. *)
axiomatization where
  explanation_1: "∀x y. VegetableOil x ∧ RenewableResource y ⟶ Is y x"

(* Explanation 2: vegetable oil is a kind of fuel. *)
axiomatization where
  explanation_2: "∀x y. VegetableOil x ∧ Fuel y ⟶ Is y x"

theorem hypothesis:
  (* Premise: Diesel engines can burn many kinds of fuel. *)
  assumes asm: "DieselEngine x ∧ Fuel y ∧ CanBurn x y"
  (* Hypothesis: Organically produced vegetable oil is the most renewable fuel for a diesel engine. *)
  shows "∃x y z e. OrganicallyProduced x ∧ VegetableOil y ∧ Fuel z ∧ DieselEngine e ∧ IsMostRenewableFuel e ∧ Is e x y ∧ Is e x z"
proof -
  from asm have "Fuel y" using asm by simp
  then have "VegetableOil y" using explanation_2 by blast
  then have "OrganicallyProduced y" by simp
  then have "DieselEngine x" using asm by blast
  then have "IsMostRenewableFuel x" by simp
  have conclusion: "VegetableOil y ∧ Fuel z" using `VegetableOil y` `Fuel y` by blast
  show ?thesis using conclusion `OrganicallyProduced y` `DieselEngine x` `IsMostRenewableFuel x` by blast
qed

end
