theory question_93_1

imports Main

begin

typedecl entity
typedecl event

consts
  AdultEchinoderms :: "entity ⇒ bool"
  RadialSymmetry :: "event ⇒ bool"
  Have :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Echinoderms :: "entity ⇒ bool"
  Starfish :: "entity ⇒ bool"
  Represented :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Adult echinoderms have radial symmetry. *)
axiomatization where
  explanation_1: "∀x e. AdultEchinoderms x ∧ RadialSymmetry e ∧ Have e ∧ Agent e x"

(* Explanation 2: Echinoderms are represented by the starfish. *)
axiomatization where
  explanation_2: "∀x y. Echinoderms x ∧ Starfish y ⟶ Represented x y"

(* Explanation 3: Starfish are a type of echinoderms. *)
axiomatization where
  explanation_3: "∀x y. Starfish x ⟶ Echinoderms y"

theorem hypothesis:
  assumes asm: "AdultEchinoderms x"
  (* Hypothesis: Adults of starfish have radial symmetry. *)
  shows "∃x e. AdultEchinoderms x ∧ RadialSymmetry e ∧ Have e ∧ Agent e x"
proof -
  from asm have "AdultEchinoderms x" by simp
  then obtain e where e: "RadialSymmetry e ∧ Have e ∧ Agent e x" using explanation_1 by blast
  then obtain y where y: "Starfish y ∧ Represented x y" using explanation_3[THEN spec, THEN spec, of x] explanation_2[THEN spec, of x] by blast
  have conclusion: "RadialSymmetry e ∧ Have e ∧ Agent e x" using e by simp
  show ?thesis using asm conclusion `Starfish y` by blast
qed

end
