theory question_91_0

imports Main

begin

typedecl entity
typedecl event

consts
  Animals :: "entity ⇒ bool"
  Hibernate :: "event ⇒ bool"
  UsedFor :: "event ⇒ bool"
  Conserve :: "event ⇒ bool"
  Energy :: "event ⇒ bool"
  Bears :: "entity ⇒ bool"

(* Explanation 1: Hibernation is used for conserving energy by some animals. *)
axiomatization where
  explanation_1: "∀x e. Animals x ∧ Hibernate e ∧ UsedFor e ∧ Conserve e ∧ Energy e"

(* Explanation 2: Bears use the fat as energy over the winter hibernation. *)
axiomatization where
  explanation_2: "∀x e. Bears x ∧ Fat e ∧ Energy e ∧ Winter e ∧ Hibernate e ∧ Use e"

theorem hypothesis:
  assumes asm: "Bears x"
  (* Hypothesis: Bears hibernate to conserve energy. *)
  shows "∃x e. Bears x ∧ Hibernate e ∧ Conserve e ∧ Energy e"
proof -
  from asm have "Bears x" by simp
  then obtain e where e: "Hibernate e ∧ Conserve e ∧ Energy e" using explanation_1 by blast
  then have "Hibernate e ∧ Conserve e ∧ Energy e" using e by blast
  show ?thesis using asm `Hibernate e ∧ Conserve e ∧ Energy e` by blast
qed

end
