theory question_75_1

imports Main

begin

typedecl entity
typedecl event

consts
  ExtremeHeat :: "entity ⇒ bool"
  Pressure :: "entity ⇒ bool"
  Rock :: "entity ⇒ bool"
  Marble :: "entity ⇒ bool"
  MetamorphicRock :: "entity ⇒ bool"
  Change :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Extreme heat and pressure change rock specifically into marble, which is a form of metamorphic rock. *)
axiomatization where
  explanation_1: "∀x y z w e. ExtremeHeat x ∧ Pressure y ∧ Rock z ∧ Marble w ∧ MetamorphicRock w ∧ Change e ∧ Agent e x ∧ Agent e y ∧ Patient e z ⟶ Patient e w"

theorem hypothesis:
  assumes asm: "ExtremeHeat x ∧ Pressure y ∧ Rock z"
  (* Hypothesis: Extreme heat and pressure change rock into marble. *)
  shows "∃x y z e w. ExtremeHeat x ∧ Pressure y ∧ Rock z ∧ Marble w ∧ MetamorphicRock w ∧ Change e ∧ Agent e x ∧ Agent e y ∧ Patient e z ∧ Patient e w"
proof -
  from asm have "ExtremeHeat x ∧ Pressure y ∧ Rock z" by simp
  then have "Marble w ∧ MetamorphicRock w ∧ Change e ∧ Agent e x ∧ Agent e y ∧ Patient e z" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
