#!/bin/bash

for random_seed in $(seq 1 10);
do
    for n_att_n_comb_n_dup in \
        "[(4, 1, 1)]" 
    do
        for ce_weight in 0.4; \
        do
            for group_size in 1;
            do
                for period in 20;
                do
                    python EGG/egg/zoo/compo_vs_generalization/train.py  \
                        --n_values=10 \
                        --n_attributes=4 \
                        --vocab_size=10 \
                        --max_len=5 \
                        --batch_size=5120 \
                        --sender_cell=gru \
                        --sender_emb=5 \
                        --sender_hidden=500 \
                        --sender_entropy_coeff=0.5 \
                        --receiver_cell=gru \
                        --receiver_emb=30 \
                        --receiver_hidden=500 \
                        --n_epoch=600 \
                        --random_seed $random_seed \
                        --wandb_project=div_int \
                        --wandb_name "u_g${group_size}_c${ce_weight}_p${period}_$n_att_n_comb_n_dup" \
                        --lr 0.001 \
                        --data_scaler=10 \
                        --n_att_n_comb_n_dup "$n_att_n_comb_n_dup" \
                        --wandb_tags "[iter_v7]" \
                        --early_stopping_thr 2.99 \
                        --validation_freq=1 \
                        --stats_freq=25 \
                        --validation_ratio 0.0 \
                        --test_ratio 0.1 \
                        --val_eval_freq 1 \
                        --test_eval_freq 1 \
                        --loss_type mixed \
                        --receiver_reset_period $period \
                        --sender_reset_period 0 \
                        --reset_type uniform \
                        --group_size $group_size \
                        --load_val_best false \
                        --reset_on_epoch true \
                        --topsim_max_samples 3000 \
                        --cross_entropy_weight $ce_weight \
                        --preserve_eos true \
                        --metric_exclude_eos true \
                        --eol_n_epochs 20
                done 
            done 
        done 
    done 
done 