import argparse

def get_args():

    parser = argparse.ArgumentParser(description="data parameters")

    parser.add_argument("--annotation_path_tr",
                        help="Path to file that contains annotations for training data.",
                        type=str,
                        default='v2_mscoco_train2014_annotations.json')

    parser.add_argument("--question_path_tr",
                        help="Path to file that contains questions for training data.",
                        type=str,
                        default='v2_OpenEnded_mscoco_train2014_questions.json')

    parser.add_argument("--annotation_path_val",
                        help="Path to file that contains annotations for validation data.",
                        type=str,
                        default='v2_mscoco_val2014_annotations.json')

    parser.add_argument("--question_path_val",
                        help="Path to file that contains questions for validation data.",
                        type=str,
                        default='v2_OpenEnded_mscoco_val2014_questions.json')

    parser.add_argument("--data_split",
                        help="Split of the dataset whose scores are to be computed. Possible options: train/val",
                        type=str,
                        default='train')

    parser.add_argument("--word2vec",
                        help="Path for word2vec model",
                        type=str,
                        default='fastText/wiki-news-300d-1M-subword.vec')

    parser.add_argument("--data_name",
                        help="Dataset name used in the experiment. Possible Types:  VQA/VizWiz",
                        type=str,
                        default='VQA')

    parser.add_argument("--pred_file",
                        help="Prediction file generated by the model.",
                        type=str,
                        default='LXMERTpreds/VQ_pred_id2scr_TrHE')

    parser.add_argument("--pred_model",
                        help="Model used to create prediction file.",
                        type=str,
                        default='lxmert')

    parser.add_argument("--id_dir",
                        help="Directory where question ids computed by SeS scores are present.",
                        type=str,
                        default='VQA2.0_ids/entropy/E_')


    args, unparsed = parser.parse_known_args()
    print(args)
    return args