from .data_config import model_type
# this module determines whether the model to be train is 
# 1. seqlabeling model with random initializtion
# 2. seqlabeling model with pretrained language model (fwd, bilm, mlm) initialization
# 3. seqclf model with random initializtion
# 4. seqclf model with pretrained language model (fwd, bilm, mlm) initialization
# 5. language model which can be (fwd, bilm, mlm) with random initialization
# 6. language model which can be (fwd, bilm, mlm) with last-time trained language model initialization

############## model type
##############

############## get Model and train, don't touch
if model_type in ['masklm', 'bilm', 'fwdlm']:
    # language model, unsupervised tasks
    from fieldlm.lm import Language_Model as Model
    from fieldlm.lm import language_model_train as train
elif model_type in ['seqlabel']:
    # sequence labeling or sequence classification, supervised tasks
    from fieldlm.seqlabel import SeqLabel as Model
    from fieldlm.seqlabel import seqlabel_train as train

elif model_type in ['seqcls']:
    from fieldlm.seqcls import SeqCls as Model
    from fieldlm.seqcls import seqcls_train as train

else:
    # errors
    raise ValueError('not a good model_type ' + model_type)
############## 


# TO EXPORT
#***********************************
# model_type
# Model 
# train
#***********************************