/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.dvparser;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.parser.dvparser.DVModel;
import edu.stanford.nlp.parser.metrics.Eval;
import edu.stanford.nlp.trees.Tree;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.TreeSet;
import org.ejml.simple.SimpleMatrix;

public class UnknownWordPrinter
implements Eval {
    final DVModel model;
    final SimpleMatrix unk;
    final TreeSet<String> unkWords = new TreeSet();

    public UnknownWordPrinter(DVModel model) {
        this.model = model;
        this.unk = model.getUnknownWordVector();
    }

    @Override
    public void evaluate(Tree guess, Tree gold) {
        this.evaluate(guess, gold, new PrintWriter(System.out, true));
    }

    @Override
    public void evaluate(Tree guess, Tree gold, PrintWriter pw) {
        this.evaluate(guess, gold, pw, 1.0);
    }

    @Override
    public void evaluate(Tree guess, Tree gold, PrintWriter pw, double weight) {
        ArrayList<Label> words = guess.yield();
        int pos = 0;
        for (Label word : words) {
            ++pos;
            SimpleMatrix wv = this.model.getWordVector(word.value());
            if (wv != this.unk && !wv.equals(this.unk)) continue;
            pw.printf("  Unknown word in position %d: %s\n", pos, word.value());
            this.unkWords.add(word.value());
        }
    }

    @Override
    public void display(boolean verbose) {
        this.display(verbose, new PrintWriter(System.out, true));
    }

    @Override
    public void display(boolean verbose, PrintWriter pw) {
        if (this.unkWords.size() == 0) {
            pw.printf("UnknownWordPrinter: all words known by DVModel\n", new Object[0]);
        } else {
            pw.printf("UnknownWordPrinter: the following words are unknown\n", new Object[0]);
            for (String word : this.unkWords) {
                pw.printf("  %s\n", word);
            }
        }
    }
}

