from transformers import AutoModelForCausalLM, AutoTokenizer


def create_LM_tokenizer(model_name, device):
    model = AutoModelForCausalLM.from_pretrained(model_name).to(device)
    tokenizer = create_tokenizer(model_name)
    return model, tokenizer


def create_tokenizer(model_name):
    tokenizer = AutoTokenizer.from_pretrained(model_name)
    tokenizer.pad_token = tokenizer.eos_token

    if 'mistral' in model_name.lower():
        tokenizer.pad_token_id = tokenizer.eos_token_id
        tokenizer.padding_side = 'left'
        print('MistralTokenizer Detected, Set pad token id and left padding!!!')

    return tokenizer


def map_model_name(model_name):
    model_name_dict = {
        'gpt-j-6b': 'EleutherAI/gpt-j-6B',
        'vicuna-7b': 'lmsys/vicuna-7b-v1.3',
        'llama-2-7b': 'meta-llama/Llama-2-7b-hf',
    }

    return model_name_dict[model_name]
