import json
import os
import random
import string

import pytest
from dotenv import load_dotenv
from openai import OpenAI

load_dotenv(override=True)

client = OpenAI(
    api_key=os.environ["OPENAI_API_KEY"],
    organization=os.environ["OPENAI_ORGANIZATION_KEY"],
)

DEAL_PROMPT = "Tell me if this pair of conversation turns indicates if a deal has been accepted. Just respond with one word, yes or no:\n\n"


def read_json(file_path):
    with open(file_path, "r") as f:
        return json.load(f)


def generate_id(length=8):
    characters = string.ascii_letters + string.digits
    return "".join(random.choice(characters) for _ in range(length))


def chatgpt_chatbot(messages, model):
    completion = client.chat.completions.create(
        model=model,
        messages=messages,
        # max_tokens=100,
        # temperature=0.1,
    )
    answer = completion.choices[0].message.content.strip()
    return answer


def random_in_last_third(num1, num2):
    # Calculate the range within the first third
    first_third_range = (num2 - num1) // 3

    # Generate a random integer within that range
    random_num = random.randint(num1 + 2 * first_third_range, num2)

    return random_num

round_num = lambda num, base: base * round(num/base)

class GPTSeller:
    def __init__(self):
        self.starting_text = {
            "role": "user",
            "content": "Begin the negotiation straight up as the seller. Open the conversation with quick casual ice breaker. Do not mention the car in this first turn.",
        }

    def load_prompt(self, params, path):
        with open(path) as f:
            instructions = f.read().format(params["current_target"], params["current_target"])
        return instructions

    def get_response(self, message, history, params):
        if len(history) == 0:
            params["turn"] = 1
            params["current_target"] = random_in_last_third(
                params["reservationPrice"], params["max_marketPrice"]
            )
            params['current_target']= round_num(params["current_target"], int(1*10**2))
            targ = params['current_target']
            print(f"Initial target for seller: {targ}")
            params["system_prompt"] = self.load_prompt(
                params=params, path="./seller_system_prompt_dynamic_floor.txt"
            )
            history.append({"role": "system", "content": params["system_prompt"]})
            history.append(self.starting_text)
        elif params["turn"] == 1:
            params["turn"] += 1
            history.append({"role": "user", "content": message + '\nRespond to the user as the seller. Do not give a counteroffer or mention a price in your response.'})
        elif params["turn"] > 4:
            params["turn"] += 1
            history[0] = {
                "role": "system",
                "content": self.load_prompt(
                    params=params, path="./seller_sytem_prompt_static.txt"
                ),
            }
            history.append({"role": "user", "content": message})
        else:
            params["turn"] += 1
            params["current_target"] = (
                params["current_target"] + params["reservationPrice"]
            ) / 2
            params['current_target'] = round_num(params["current_target"], int(1*10**2))
            history[0] = {
                "role": "system",
                "content": self.load_prompt(
                    params=params, path="./seller_system_prompt_dynamic_floor.txt"
                ),
            }
            history.append({"role": "user", "content": message})

        response = chatgpt_chatbot(history, "gpt-4")
        history.append({"role": "assistant", "content": response})
        params["episode_done"] = True if params["turn"] >= 7 else False
        return dict(
            response=response.replace("\n", " "), history=history, parameters=params
        )


if __name__ == "__main__":
    config_path = "seller_config_example.json"

    configs = read_json(config_path)

    seller = GPTSeller()

    # Start the conversation
    history = []
    params = dict(
        episode_done=False,
        reservationPrice=configs['units'][0]['parameters']['reservationPrice'][0],
        max_marketPrice=configs['units'][0]['parameters']['max_marketPrice'][0]
    )

    user_text = ""
    output = seller.get_response(user_text, history, params)
    print(f"Bot: {output['response']}")

    while True:
        user_text = input("You: ")
        if user_text == "quit":
            break
        output = seller.get_response(user_text, history, params)
        history = output["history"]
        # Specify the file path where you want to save the JSON file
        file_path = "../feedback_module/history_temp.json"

        # Write the dictionary to a JSON file
        with open(file_path, "w") as json_file:
            json.dump(history[2:], json_file)

        params = output["parameters"]
        print(params["turn"])
        targ = params['current_target']
        print(f"Next target for seller: {targ}")
        # print(f"History at the moment: {history}")
        # print(params['episode_done'])
        print(f"Bot: {output['response']}")
