import argparse
import asyncio
import sys

import flask
from flask import Flask, jsonify, request
from flask_cors import CORS
from modules import GPTSeller

sys.path.insert(0, "../")

seller = GPTSeller()

parser = argparse.ArgumentParser(description="Simple API for chat bot")
parser.add_argument(
    "--hostname", default="localhost", help="web server hostname."
)
parser.add_argument("--port", type=int, default=35496, help="web server port.")
parser.add_argument(
    "--serving_hostname", default="0.0.0.0", help="API web server hostname."
)
parser.add_argument(
    "--serving_port", type=int, default=8080, help="API web server port."
)

args = parser.parse_args()

hostname = args.hostname
port = args.port
serving_hostname = args.serving_hostname
serving_port = args.serving_port

app = Flask(__name__)
CORS(app)
blueprint = flask.Blueprint("seller_bot", __name__, template_folder="templates")

TURN_LOOKUP = {}
websocket_uri = f"ws://{hostname}:{port}/websocket"

PUNK = ["?", ".", "!"]


def process(phrase):
    new_phrase = phrase.capitalize()

    for i in PUNK:
        new_phrase = new_phrase.replace(" " + i, i)

    for i in PUNK:
        delim = i + " "
        sents = new_phrase.split(delim)
        new_sents = []
        for j in sents:
            new_sents.append(j[:1].upper() + j[1:])
        new_phrase = delim.join(new_sents)
    new_phrase = new_phrase.replace(" i ", " I ")
    return new_phrase.replace(" ,", ",")


class SellerBot:
    @staticmethod
    async def send_message(text, history, params):
        return seller.get_response(text, history, params)


@blueprint.route("/api/v1/interact", methods=["POST"])
def send():
    data = request.get_json()

    loop = asyncio.new_event_loop()
    asyncio.set_event_loop(loop)

    text, history, parameters = (
        data.get("user_text", None),
        data.get("history", []),
        data.get("parameters", {}),
    )
    unit = data["unit"]
    parameters["episode_done"] = parameters.get("episode_done", True)
    parameters["ep_done"] = parameters.get("ep_done", False)
    result = loop.run_until_complete(SellerBot.send_message(text, history, parameters))
    print(result)

    ep_done = result["parameters"]["episode_done"]

    result["episode_done"] = ep_done
    # result['response'] = result['text']
    return result


@blueprint.route("/health", methods=["GET"])
def get_health():
    return "OK"


async def main():
    app.register_blueprint(blueprint)
    app.run(host=serving_hostname, port=serving_port)


main_loop = asyncio.get_event_loop()
main_loop.run_until_complete(main())
