#!/usr/bin/env bash
echo usage: 
echo scriptName.sh : run in normal mode
echo scriptName.sh debug : run in debug mode

# hardware
cudaID=$2

# debug mode
if [[ $# != 0 ]] && [[ $1 == "debug" ]]
then
    debug=true
else
    debug=false
fi

# seed=4321
# seed=1
seed=1
seedList=(1 2 3 4 5)

# wandb
wandb=--wandb
wandb=
wandbProj=SPT_Cor-Reg
# dataset
dataDir='OOS,bank77,HINT3'

# sourceDomain="utility,home,meta,small_talk,travel,kitchen_dining"
# valDomain="auto_commute,work"
sourceDomain="utility,auto_commute,work,home,meta,small_talk"
valDomain="travel,kitchen_dining"
# valDomain="curekart,powerplay11,sofmattress"
# valDomain="BANKING"

# below is only for evaluation
targetDomain="BANKING"
# targetDomain="MEDICAL"
# targetDomain="curekart,powerplay11,sofmattress"

# setting
epochs=5
taskNum=200
shot=2

# training
covThreshold=150.0
weightDecay=0.001
tensorboard=
validation=--validation
mlm=
learningRate=2e-5
# learningRate=5e-6
batchMonitor=50
patience=20

# model setting
# common
LMName=bert-base-uncased
beforeBatchNorm=--beforeBatchNorm
lossCovWeight=0.04

numSynthesis=0
numSynthesisList=(0)
saveModel=--saveModel
# saveName=seed${seed}

# modify arguments if it's debug mode
RED='\033[0;31m'
GRN='\033[0;32m'
NC='\033[0m' # No Color
if $debug
then
    echo -e "Run in ${RED} debug ${NC} mode."
    epochs=2
    wandb=
else
    echo -e "Run in ${GRN} normal ${NC} mode."
fi

echo "Start Experiment ..."
for seed in ${seedList[@]}
do
    logFolder=./log/
    mkdir -p ${logFolder}
    logFile=${logFolder}/transfer_${sourceDomain}_${way}way_${shot}_seed${seed}_lossCovWeight${lossCovWeight}_val${valDomain}.log
    # logFile=${logFolder}/transfer_mlm_${sourceDomainName}_to_${targetDomainName}_${way}way_${shot}shot.log
    if $debug
    then
        logFlie=${logFolder}/logDebug.log
    fi

    saveName=syn${numSynthesis}_seed${seed}_lossCovWeight${lossCovWeight}_val${valDomain}

    export CUDA_VISIBLE_DEVICES=${cudaID}
    python transfer.py \
        --seed ${seed} \
        --epochs ${epochs}  \
        --valDomain  ${valDomain}  \
        --sourceDomain ${sourceDomain} \
        --targetDomain ${targetDomain} \
        ${tensorboard} \
        --dataDir ${dataDir} \
        --shot ${shot}  \
        ${saveModel} \
        ${validation} \
        ${mlm} \
        ${wandb}  \
        --weightDecay  ${weightDecay} \
        --wandbProj  ${wandbProj}  \
        --learningRate  ${learningRate} \
        --batchMonitor  ${batchMonitor} \
        --LMName ${LMName} \
        --saveName ${saveName} \
        --taskNum ${taskNum} \
        ${beforeBatchNorm}   \
        --patience  ${patience} \
        --lossCovWeight  ${lossCovWeight} \
        --covThreshold  ${covThreshold} \
        --numSynthesis ${numSynthesis}  \
        | tee "${logFile}"
    done
echo "Experiment finished."
