import torch
import torch.nn as nn


class Feedforward(nn.Module):
    """
    Apply feedforward computation to the last dimension of a tensor.
    """
    def __init__(self, input_dim, hidden_dim, output_dim, dropout_p, activation='relu', bias1=True, bias2=True):
        super().__init__()
        self.activation = activation 
        self.input_dropout = nn.Dropout(dropout_p)
        self.hidden_dropout = nn.Dropout(dropout_p)
        self.linear1 = nn.Linear(input_dim, hidden_dim, bias=bias1)
        self.linear2 = nn.Linear(hidden_dim, output_dim, bias=bias2)

    def forward(self, x):
        return self.linear2(
                 self.hidden_dropout(
                   getattr(torch, self.activation)(
                     self.linear1(
                        self.input_dropout(x)))))
