#!/bin/sh
#PBS -q h-regular
#PBS -l select=1
#PBS -W group_list=gk77
#PBS -l walltime=18:00:00
#PBS -N LISA-DEBUG-SD-UP-LABELED-MVNORM
#PBS -j oe
#PBS -M christopher@orudo.cc
#PBS -m abe

export PATH=$PBS_O_PATH:$PATH

cd $PBS_O_WORKDIR
SAVEDIR=.model/lisa/discounting/glove/labeled-relchain-debug/conll05-lisa-labeled-mvnorm-up
CONF=config/lisa/discounting/glove/conll05-lisa-labeled-u.conf
SINGULARITY_IMG=/lustre/gk77/k77015/.Singularity/imgs/LISA.simg
ADDITIONAL_PARAMETERS=" --debug --hparam transformation_fn_norm=mean_var_norm"

module add cuda9/9.0.176-cuDNN7.1.4 singularity/2.5.1
{
CUDA_VISIBLE_DEVICES=0 singularity exec --nv $SINGULARITY_IMG bin/train.sh $CONF --save_dir $SAVEDIR/run-1 --num_gpus 1 $ADDITIONAL_PARAMETERS &> $SAVEDIR/run-1/train.log
} &

{
sleep 600
CUDA_VISIBLE_DEVICES=1 singularity exec --nv $SINGULARITY_IMG bin/train.sh $CONF --save_dir $SAVEDIR/run-2 --num_gpus 1 $ADDITIONAL_PARAMETERS &> $SAVEDIR/run-2/train.log
} &
wait
