class TextCNNConfig:
    name = 'textcnn'
    embed_size = 300
    num_channels = 100
    kernel_size = [3, 5, 7]
    max_sen_len = 256
    output_size = 4
    dropout = 0.5


class LSTMConfig():
    name = 'lstm'
    embed_size = 300
    hidden_layers = 2
    hidden_size = 32
    bidirectional = True
    output_size = 4
    max_sen_len = 256 # Sequence length for RNN
    dropout_keep = 0.5


class Config:
    def __init__(self, data=None, model=None, task=None):
        self.task = task
        if data == 'sentiment':
            self.loss = [0.01683, 0.02191, 0.01796, 0.01639, 0.01849, 0.01784, 0.01802, 0.01649, 0.013, 0.0194, 0.01847, 0.01727, 0.01757, 0.01498]
            self.w = [0.07315, 0.05619, 0.06855, 0.07511, 0.06658, 0.06901, 0.06832, 0.07466, 0.09470, 0.06346, 0.06665, 0.07129, 0.07007, 0.08219]
            self.data = {
                'name': 'sentiment',
                'tasks': ['apparel', 'baby', 'books', 'camera_photo', 'dvd', 'electronics', 'health_personal_care', 'kitchen_housewares', 'magazines', 'music', 'software', 'sports_outdoors', 'toys_games', 'video'],
                'processes': 14,
                'batch_size': 256,
            }
            if task == 'single':
                self.exp = {
                    'lr': 1e-2,
                    'step': 10,
                    'epochs': 500,
                }
            if task == 'uniform':
                self.exp = {
                    'opt': 'Adam',
                    'lr': 1e-3,
                    'epochs': 2000,
                }
            if task == 'mgda':
                self.exp = {
                    'opt': 'Adam',
                    'lr': 1e-3,
                    'epochs': 2000,
                }
            if task == 'fudan':
                self.exp = {
                    'opt': 'Adam',
                    'lr': 1e-3,
                    'epochs': 2000,
                }
            if task == 'tchebycheff':
                self.checkpoint = 'checkpoints/sentiment/single/magazines_400'
                self.exp = {
                    'opt': 'Adam',
                    'lr': 3e-4,
                    'epochs': 4000,
                }
            if task == 'tchebycheff_adv':
                self.checkpoint = 'checkpoints/sentiment/single/magazines_400'
                self.exp = {
                    'alpha': 2.5,
                    'beta': 0.001 / len(self.data['tasks']),
                    'opt': 'Adam',
                    'lr': 1e-4,
                    'epochs': 10000,
                    'dis': True
                }
        if data == '20news':
            self.loss = [0.1367, 0.0560, 0.04485, 0.07462]
            self.w = [0.1201, 0.2933, 0.3662, 0.2201]
            self.data = {
                'name': '20news',
                'tasks': ['comp', 'rec', 'sci', 'talk'],
                'topics': [
                    ['os.ms-windows.misc', 'sys.mac.hardware', 'graphics', 'windows.x'],
                    ['sport.baseball', 'sport.hockey', 'autos', 'motorcycles'],
                    ['crypt', 'electronics', 'med', 'space'],
                    ['politics.mideast', 'religion.misc', 'politics.misc', 'politics.guns']
                ],
                'processes': 16,
                'batch_size': 256
            }
            if task == 'single':
                self.exp = {
                    'lr': 1e-2,
                    'step': 10,
                    'epochs': 500,
                }
            if task == 'uniform':
                self.exp = {
                    'opt': 'Adam',
                    'lr': 1e-3,
                    'step': 10,
                    'epochs': 2000,
                }
            if task == 'mgda':
                self.exp = {
                    'opt': 'Adam',
                    'lr': 1e-3,
                    'step': 10,
                    'epochs': 3000,
                }
            if task == 'fudan':
                self.exp = {
                    'opt': 'Adam',
                    'lr': 1e-4,
                    'wd': 1e-5,
                    'step': 10,
                    'epochs': 2000,
                }
            if task == 'tchebycheff':
                self.checkpoint = 'checkpoints/20news/single/sci_400'
                self.exp = {
                    'opt': 'Adam',
                    'lr': 3e-4,
                    'epochs': 4000,
                }
            if task == 'tchebycheff_adv':
                self.checkpoint = 'checkpoints/20news/single/sci_400'
                self.exp = {
                    'alpha': 1,
                    'beta': 0.1 / len(self.data['tasks']),
                    'opt': 'Adam',
                    'lr': 3e-4,
                    'epochs': 4000,
                    'dis': True
                }
        if model == 'textcnn':
            self.model = TextCNNConfig()
        elif model == 'lstm':
            self.model = LSTMConfig()
