/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import simplenlg.exception.SimplenlgException;
import simplenlg.features.AdjectiveDegree;
import simplenlg.features.AdjectiveType;
import simplenlg.features.Case;
import simplenlg.features.Category;
import simplenlg.features.Gender;
import simplenlg.features.NumberAgr;
import simplenlg.lexicon.lexicalitems.Adjective;
import simplenlg.lexicon.morph.AdjectiveInflection;
import simplenlg.realiser.CoordinateAdjPhraseSpec;
import simplenlg.realiser.HeadedPhraseSpec;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.Realiser;

public class AdjPhraseSpec
extends HeadedPhraseSpec<Adjective> {
    NumberAgr number;
    Gender gender;
    Case cas;
    AdjectiveType adjType;
    AdjectiveDegree adjDegree;

    public AdjPhraseSpec() {
        this.head = new Adjective("");
        this.number = NumberAgr.SINGULAR;
        this.gender = Gender.NEUTER;
        this.cas = Case.NOMINATIVE;
        this.adjType = AdjectiveType.UNINFLECTED;
        this.adjDegree = AdjectiveDegree.POSITIVE;
        this.category = Category.ADJECTIVE;
    }

    public AdjPhraseSpec(String adj) {
        this();
        this.setHead(adj);
    }

    public AdjPhraseSpec(Adjective adj) {
        this();
        this.setHead(adj);
    }

    public void setPlural(boolean plur) {
        this.number = plur ? NumberAgr.PLURAL : NumberAgr.SINGULAR;
    }

    public boolean isPlural() {
        return this.number.equals(NumberAgr.PLURAL);
    }

    public void setNumber(NumberAgr n) {
        this.number = n;
    }

    public NumberAgr getNumber() {
        return this.number;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public Case getCase() {
        return this.cas;
    }

    public void setCase(Case cas) {
        this.cas = cas;
    }

    public AdjectiveType getAdjType() {
        return this.adjType;
    }

    public void setAdjType(AdjectiveType adjType) {
        this.adjType = adjType;
    }

    public AdjectiveDegree getDegree() {
        return this.adjDegree;
    }

    public void setDegree(AdjectiveDegree adjDegree) {
        this.adjDegree = adjDegree;
    }

    @Override
    public void setHead(String adj) {
        this.head = new Adjective(adj);
    }

    public void setAgreementNP(NPPhraseSpec np) {
        this.setNumber(np.getNumber());
        this.setCase(np.getCase());
        this.setGender(np.getGender());
        this.setAdjType(AdjectiveInflection.determineAdjectiveType(np.getSpecifier(), np.isPlural()));
    }

    public AdjPhraseSpec coordinate(Phrase ... coords) {
        CoordinateAdjPhraseSpec coord = new CoordinateAdjPhraseSpec(this);
        if (coords.length == 0) {
            return this;
        }
        try {
            for (Phrase p : coords) {
                coord.addCoordinates((AdjPhraseSpec)p);
            }
            return coord;
        }
        catch (ClassCastException cce) {
            throw new SimplenlgException("Cannot coordinate: only phrases of the same type can be coordinated");
        }
    }

    @Override
    String realise(Realiser r) {
        String compText = "";
        String negText = "";
        if (this.hasComplements()) {
            this.setComplementCase();
            if (this.adjDegree == AdjectiveDegree.POSITIVE || this.adjDegree == AdjectiveDegree.SUPERLATIVE) {
                compText = "wie";
            } else if (this.adjDegree == AdjectiveDegree.COMPARATIVE) {
                compText = "als";
            }
        }
        if (this.negated) {
            negText = "nicht";
        }
        return r.appendSpace(negText, this.realisePremodifier(r), this.realiseHead(r), compText, this.realiseComplement(r), this.realisePostmodifier(r));
    }

    private void setComplementCase() {
        for (Phrase p : this.complements) {
            if (!(p instanceof NPPhraseSpec)) continue;
            ((NPPhraseSpec)p).setCase(Case.NOMINATIVE);
        }
    }

    @Override
    String realiseHead(Realiser r) {
        if (this.head == null || ((Adjective)this.head).getBaseForm() == null || ((Adjective)this.head).getBaseForm().length() == 0) {
            return "";
        }
        return ((Adjective)this.head).getForm(this.cas, this.number, this.gender, this.adjType, this.adjDegree);
    }
}

