/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.lexicalitems;

import simplenlg.features.Category;
import simplenlg.features.ConjunctionType;
import simplenlg.lexicon.LexiconInterface;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Word;

public class Conjunction
extends Word {
    private ConjunctionType conjType;
    private Category categoryRestriction;

    public Conjunction(String baseform) {
        super(baseform);
        this.setCitationForm(baseform);
        this.category = Category.CONJUNCTION;
        this.conjType = ConjunctionType.COORDINATING;
        this.categoryRestriction = Category.ANY;
    }

    public Conjunction(String id, String baseform) {
        this(baseform);
        this.setID(id);
    }

    public Conjunction(String id, String baseform, String citationform) {
        this(id, baseform);
        this.setCitationForm(citationform);
    }

    public Conjunction(String form, ConjunctionType t) {
        this(form);
        this.conjType = t;
    }

    @Deprecated
    public Conjunction(String form, LexiconInterface parentLexicon) {
        super(form, parentLexicon);
        this.category = Category.CONJUNCTION;
        this.conjType = ConjunctionType.COORDINATING;
    }

    public ConjunctionType getConjType() {
        return this.conjType;
    }

    public void setConjType(ConjunctionType conjType) {
        this.conjType = conjType;
    }

    public Category getCategoryRestriction() {
        return this.categoryRestriction;
    }

    public void setCategoryRestriction(Category categoryRestriction) {
        this.categoryRestriction = categoryRestriction;
    }

    public boolean canConjoin(Category cat) {
        return this.categoryRestriction.equals((Object)Category.ANY) || cat.equals((Object)this.categoryRestriction);
    }

    @Deprecated
    public static Conjunction getConjunction(String s) {
        return Constants.getConjunction(s);
    }

    public boolean isCoordinating() {
        return this.conjType == ConjunctionType.COORDINATING;
    }

    public boolean isSubordinating() {
        return this.conjType == ConjunctionType.SUBORDINATING;
    }
}

