/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.THashIterator;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectHashIterator;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class THashMap
extends TObjectHash
implements Map,
Serializable {
    protected transient Object[] _values;

    public THashMap() {
    }

    public THashMap(TObjectHashingStrategy strategy) {
        super(strategy);
    }

    public THashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public THashMap(int initialCapacity, TObjectHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public THashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public THashMap(int initialCapacity, float loadFactor, TObjectHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public THashMap(Map map) {
        this(map.size());
        this.putAll(map);
    }

    public THashMap(Map map, TObjectHashingStrategy strategy) {
        this(map.size(), strategy);
        this.putAll(map);
    }

    public Object clone() {
        THashMap m = (THashMap)super.clone();
        m._values = (Object[])this._values.clone();
        return m;
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        return capacity;
    }

    public Object put(Object key, Object value) {
        if (null == key) {
            throw new NullPointerException("null keys not supported");
        }
        Object previous = null;
        Object oldKey = null;
        int index = this.insertionIndex(key);
        if (index < 0) {
            index = -index - 1;
            previous = this._values[index];
        }
        oldKey = this._set[index];
        this._set[index] = key;
        this._values[index] = value;
        if (null == previous) {
            this.postInsertHook(oldKey == null);
        }
        return previous;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Map)) {
            return false;
        }
        Map that = (Map)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public boolean forEachKey(TObjectProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TObjectProcedure procedure) {
        Object[] values = this._values;
        Object[] set = this._set;
        int i = values.length;
        while (i-- > 0) {
            if (set[i] == null || set[i] == REMOVED || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectObjectProcedure procedure) {
        Object[] keys = this._set;
        Object[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TObjectObjectProcedure procedure) {
        boolean modified = false;
        Object[] keys = this._set;
        Object[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
            this.removeAt(i);
            modified = true;
        }
        return modified;
    }

    public void transformValues(TObjectFunction function) {
        Object[] values = this._values;
        Object[] set = this._set;
        int i = values.length;
        while (i-- > 0) {
            if (set[i] == null || set[i] == REMOVED) continue;
            values[i] = function.execute(values[i]);
        }
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldKeys = this._set;
        Object[] oldVals = this._values;
        this._set = new Object[newCapacity];
        this._values = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == null || oldKeys[i] == REMOVED) continue;
            Object o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
        }
    }

    public Object get(Object key) {
        int index = this.index(key);
        return index < 0 ? null : this._values[index];
    }

    public void clear() {
        super.clear();
        Object[] keys = this._set;
        Object[] vals = this._values;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = null;
            vals[i] = null;
        }
    }

    public Object remove(Object key) {
        Object prev = null;
        int index = this.index(key);
        if (index >= 0) {
            prev = this._values[index];
            this.removeAt(index);
        }
        return prev;
    }

    protected void removeAt(int index) {
        super.removeAt(index);
        this._values[index] = null;
    }

    public Collection values() {
        return new ValueView();
    }

    public Set keySet() {
        return new KeyView();
    }

    public Set entrySet() {
        return new EntryView();
    }

    public boolean containsValue(Object val) {
        Object[] set = this._set;
        Object[] vals = this._values;
        if (null == val) {
            int i = vals.length;
            while (i-- > 0) {
                if (set[i] == null || set[i] == REMOVED || val != vals[i]) continue;
                return true;
            }
        } else {
            int i = vals.length;
            while (i-- > 0) {
                if (set[i] == null || set[i] == REMOVED || val != vals[i] && !val.equals(vals[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(Object key) {
        return this.contains(key);
    }

    public void putAll(Map map) {
        this.ensureCapacity(map.size());
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            Object key = stream.readObject();
            Object val = stream.readObject();
            this.put(key, val);
        }
    }

    final class Entry
    implements Map.Entry {
        private final Object key;
        private Object val;
        private final int index;

        Entry(Object key, Object value, int index) {
            this.key = key;
            this.val = value;
            this.index = index;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.val;
        }

        public Object setValue(Object o) {
            if (THashMap.this._values[this.index] != this.val) {
                throw new ConcurrentModificationException();
            }
            THashMap.this._values[this.index] = o;
            this.val = o = this.val;
            return o;
        }
    }

    protected class KeyView
    implements Set {
        protected KeyView() {
        }

        public Iterator iterator() {
            return new TObjectHashIterator(THashMap.this);
        }

        public boolean remove(Object key) {
            return null != THashMap.this.remove(key);
        }

        public boolean contains(Object key) {
            return THashMap.this.contains(key);
        }

        public boolean containsAll(Collection collection) {
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                if (this.contains(i.next())) continue;
                return false;
            }
            return true;
        }

        public boolean removeAll(Collection collection) {
            boolean changed = false;
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                if (!this.remove(i.next())) continue;
                changed = true;
            }
            return changed;
        }

        public void clear() {
            THashMap.this.clear();
        }

        public boolean add(Object obj) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return THashMap.this.size();
        }

        public Object[] toArray() {
            Object[] result = new Object[this.size()];
            Iterator e = this.iterator();
            int i = 0;
            while (e.hasNext()) {
                result[i] = e.next();
                ++i;
            }
            return result;
        }

        public Object[] toArray(Object[] a) {
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            Iterator it = this.iterator();
            for (int i = 0; i < size; ++i) {
                a[i] = it.next();
            }
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        public boolean isEmpty() {
            return THashMap.this.isEmpty();
        }

        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection collection) {
            boolean changed = false;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (collection.contains(i.next())) continue;
                i.remove();
                changed = true;
            }
            return changed;
        }

        protected final class EntryIterator
        extends THashIterator {
            EntryIterator(THashMap map) {
                super(map);
            }

            public Object objectAtIndex(int index) {
                return new Entry(((KeyView)KeyView.this).THashMap.this._set[index], ((KeyView)KeyView.this).THashMap.this._values[index], index);
            }
        }
    }

    protected class EntryView
    extends KeyView {
        protected EntryView() {
        }

        public Iterator iterator() {
            return new KeyView.EntryIterator(THashMap.this);
        }

        public boolean remove(Object entry) {
            Object val;
            Object key = this.keyForEntry(entry);
            int index = THashMap.this.index(key);
            if (index >= 0 && ((val = this.valueForEntry(entry)) == THashMap.this._values[index] || null != val && val.equals(THashMap.this._values[index]))) {
                THashMap.this.removeAt(index);
                return true;
            }
            return false;
        }

        public boolean contains(Object entry) {
            Object val = THashMap.this.get(this.keyForEntry(entry));
            Object entryValue = ((Map.Entry)entry).getValue();
            return entryValue == val || null != val && val.equals(entryValue);
        }

        protected Object valueForEntry(Object entry) {
            return ((Map.Entry)entry).getValue();
        }

        protected Object keyForEntry(Object entry) {
            return ((Map.Entry)entry).getKey();
        }
    }

    protected class ValueView
    extends KeyView {
        protected ValueView() {
        }

        public Iterator iterator() {
            return new THashIterator(THashMap.this){

                protected Object objectAtIndex(int index) {
                    return ((ValueView)ValueView.this).THashMap.this._values[index];
                }
            };
        }

        public boolean contains(Object value) {
            return THashMap.this.containsValue(value);
        }

        public boolean remove(Object value) {
            boolean changed = false;
            Object[] values = THashMap.this._values;
            Object[] set = THashMap.this._set;
            int i = values.length;
            while (i-- > 0) {
                if ((set[i] == null || set[i] == TObjectHash.REMOVED || value != values[i]) && (null == values[i] || !values[i].equals(value))) continue;
                THashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }
    }

    private static final class EqProcedure
    implements TObjectObjectProcedure {
        private final Map _otherMap;

        EqProcedure(Map otherMap) {
            this._otherMap = otherMap;
        }

        public final boolean execute(Object key, Object value) {
            Object oValue = this._otherMap.get(key);
            return oValue == value || oValue != null && oValue.equals(value);
        }
    }
}

