
package edu.umn.cs.nlp.textproc;
import java.util.Vector;

public class Tree{

  protected String cat;
  public Vector<Tree> children;
  Tree parent=null;
  
  public Tree(Tree p){
    this("", p);
  }
  
  public Tree(String s){
    this(s, null);
  }
  
  public Tree(String s, Tree parent){
    children = new Vector<Tree>();
    this.parent = parent;
    this.buildStructure(s);
  }
  
  public String buildStructure(String s){
    if(s.equals("")){
      return "";
    }else{
      // check for some weird trees that start with two parens with a space
      // between them...
      if(s.startsWith("( (")){
        s = s.substring(2);
      }
      
      // break off the category
      if(s.startsWith("(")){
        int space = s.indexOf(' ');
        cat = s.substring(1,space); // everything after the paren to the space is the category...
        s = s.substring(space);     // everything after the space is the rest...
        while(true){
          if(s.startsWith("(")){
            // start of a child...
            Tree child = new Tree(this);
            s = child.buildStructure(s);
            children.add(child);
          }else if(s.startsWith((")"))){
            // end of a tree...
            s = s.substring(1);
            return s;
          }else if(s.startsWith(" ")){
            // space!
            s = s.substring(1);
          }else{
            // terminal symbol
            int rparen = s.indexOf(")");
            String word = s.substring(0,rparen);
            Tree child = new Tree(this);
            child.setCategory(word);
            children.add(child);
            s = s.substring(rparen+1);
            return s;
          }
        }
      }
    }
    System.err.println("ERROR: Should not reach this point in Tree()!");
    return "";
  }
  
  public boolean isRoot(){
    return (parent == null);
  }
  
  public boolean hasParent(){
    return !isRoot();
  }
  
  public void setCategory(String c){
    cat = c;
  }
  
  public String getCategory(){
    return cat;
  }
  
  public String getCat(){
    return cat;
  }
  
  public String toString(){
    if(children.size() == 0){
        return cat;
    }else{
        String s = "(" + cat + " ";
        for(int i = 0; i < children.size()-1; i++){
          s += children.get(i).toString() + " ";
        }
        s += children.get(children.size()-1).toString();
        s += ")";
        return s;
    }
  }
  
  public boolean isPreterm(){
	  return (children.size() == 1 && children.get(0).children.size() == 0);
  }
  
  public static void main(String[] args){
    Tree tree = new Tree(args[0]);
    System.out.println("Read in tree: " + tree);
  }
}

