import json
import os

from venus_api_base.http_client import HttpClient
from venus_api_base.config import Config

class VenusClient(object):
    def __init__(self, secret_id="OEiMzr4ppztqxpYwPG4qCfM2", secret_key="qZoBzu90bwHqa6fRDQBO5qZt", app_group_id=876, model=236050, do_sample=False, temperature=0.95, top_p=0.7, use_sys="", **kwargs):
        """
        Args:
            model: [236050, "llama3-70b-instruct"]
        """
        self.app_group_id = app_group_id
        
        if isinstance(model, int):
            self.is_service = True
        else:
            self.is_service = False

        self.client = HttpClient(secret_id=secret_id, secret_key=secret_key, config=Config())
        self.header = {'Content-Type': 'application/json'}
        self.do_sample = do_sample
        self.temperature = temperature
        self.top_p = top_p
        self.model = model
        self.use_sys = use_sys

        print(f'Successfully connect to venus service: {self.model}')

    def single_chat(self, query):
        if self.is_service:
            body = {
            'appGroupId': self.app_group_id,
            'serverId': self.model,
            'request': query,
            'do_sample': self.do_sample,
            'temperature': self.temperature,
            'top_p': self.top_p
            }

        else:
            if self.use_sys:
                msg = [
                    {"role": "system", "content": self.use_sys},
                    {"role": "user", "content": query}
                ]
            else:
                msg = [
                    {"role": "user", "content": query}
                ]

            body = {
            'appGroupId': self.app_group_id,
            'model': self.model,
            'messages': msg,
            'do_sample': self.do_sample,
            'temperature': self.temperature,
            'top_p': self.top_p
            }
        
        try:
            ret = self.client.post('http://v2.open.venus.oa.com/chat/single', header=self.header, body=json.dumps(body))
            assert ret is not None, f'Wrong return: {ret}'
            assert ret['code'] == 0, f'Wrong return: {ret}'
            return ret['data']['response']
        except Exception as err:  # pylint: disable=broad-except
            print(f'Error: {err}')
            return ''


if __name__ == '__main__':
    service = VenusClient()

    post = "He spent his entire summer on his computer playing league of legends until 5am, up at 11am and doing the same thing the next day. The people he play with are all in the USA, and we live in Ireland. My mum had tried to stop him but she works throughout the day, as do I. He wont see anyone from school, is reluctant to leave his room, and at one point said to me that \"its the only place I feel safe\". \n\nAnyway, I'd often seen him on tumblr writing some blog, which he told me recently was a My Little Pony fan fiction blog. Weird I thought, but I know some people are into that. However, my sister and he went over to the US to visit our cousins in Virginia for a few weeks last month, and he brought back with him about $250 (**all** his spending money) worth of this MLP crap, dvds, wallets, figurines, t-shirts. Ok I thought, getting weirder but I'll leave him to it. But over the weekend we were all at a family reunion and he was on my grandmothers computer and my sister asked to use it. When he gave it to her he'd left open a tumblr which was fan art of these pony's with tits, and jizz all over them. A lot of these pictures. She naturally asked him what the fuck it was, and he replied that its not weird its just tumblr, like it was a completely normal thing.\n\nSo hes back at school now, comes home and is on the computer looking at this weird shit and not leaving his room. My mum and I have tried to get him out doing physical stuff, but I work late and at the weekends and she has long hours and my sisters in college so its difficult. \n\nWhat do you recommend I do to get him away from this weird shit?"
    baseline_response = "16 year old brother spends all free time looking at my little pony fan porn, and writing fan fiction, and not socialising with anyone, apart from his internet friends. How do I get him to stop?"
    candidate_response = "The main issue presented in this forum post is the concern of the author regarding the behavior of her son, who is spending excessive amounts of time on the computer playing a video game, and is also spending a significant amount of money on merchandise related to this game.  The author is concerned about the negative impact this behavior is having on her son, and is seeking advice on how to address this issue."
    query = f"Which of the following summaries does a better job of summarizing the most important points in the given form post, without including unimportant or irrelevant details? A good summary is both precise and concise.\n\nPost:\n{post}\n\nSummary A:\n{baseline_response}\n\nSummary B:\n{candidate_response}\n\nFIRST provide a one-sentence comparison of the two summaries, explaining which you prefer and why. SECOND, on a new line, state only 'A' or 'B' to indicate your choice. Your response should use the format:\nComparison:<one-sentence comparison and explanation>\nPreferred: <'A' or 'B'>"
    
    for i in range(20):
        ret = service.single_chat(query)
        print(ret)