seed=777
run_name="PGF"
size="base"

# path info
path="/main/path/"
oscar_pretrained_model_path="${path}/path/to/${size}"
output_path="${path}/output/PGF/coco_ic/${run_name}"

ce_output_path="${output_path}/PGF_${i}_base_ce/"
ce_model_path="${ce_output_path}/wandb/latest-run/files/best"
ce_eval_output_path="${ce_output_path}/wandb/latest-run/files"

scst_output_path="${output_path}/PGF_${i}_base_scst/"
scst_model_path="${scst_output_path}/wandb/latest-run/files/best"
scst_eval_output_path="${scst_output_path}/wandb/latest-run/files"
scst_path_dir="${scst_eval_output_path}/checkpoint*"


# random id
random_id=$(cat /dev/urandom | tr -dc 'A-Z' | fold -w 2 | sed 1q)

# PT training
torchrun \
--nproc_per_node=8 \
./task/captioning/main.py \
--cfg ./config/coco/base_ce_prefix_1_cfg.yaml  \
--name "PGF_${i}_${run_name}_${size}_ce_seed_${seed}_id_${random_id}" \
--seed $seed \
--num_train_epochs 30 \
--warmup_step_ratio 0.1 \
--plateau_step_ratio 0.3 \
--learning_rate 1.0e-5 \
--mask_t_i False \
--freeze_backbone True \
--model_name_or_path ${oscar_pretrained_model_path} \
--output_dir $ce_output_path \
--num_prefix $i

# CE best model test
torchrun \
--nproc_per_node=8 \
./task/captioning/main.py \
--cfg ./config/coco/base_test_prefix_1_cfg.yaml  \
--eval_model_dir $ce_model_path \
--mask_t_i False \
--num_prefix $i \
--output_dir $ce_eval_output_path

# CE training
torchrun \
--nproc_per_node=8 \
./task/captioning/main.py \
--cfg ./config/coco/base_ce_prefix_1_cfg.yaml  \
--name "PGF_${i}_${run_name}_${size}_ce_seed_${seed}_id_${random_id}" \
--seed $seed \
--num_train_epochs 40 \
--warmup_step_ratio 0.1 \
--plateau_step_ratio 0.3 \
--learning_rate 1.0e-5 \
--mask_t_i False \
--freeze_backbone False \
--model_name_or_path ${oscar_pretrained_model_path} \
--output_dir $ce_output_path \
--num_prefix $i

# CE best model test
torchrun \
--nproc_per_node=8 \
./task/captioning/main.py \
--cfg ./config/coco/base_test_prefix_1_cfg.yaml  \
--eval_model_dir $ce_model_path \
--mask_t_i False \
--num_prefix $i \
--output_dir $ce_eval_output_path

# SCST training
torchrun \
--nproc_per_node=8 \
./task/captioning/main.py \
--cfg ./config/coco/base_scst_prefix_1_cfg.yaml  \
--name "PGF_${i}_${run_name}_${size}_scst_seed_${seed}_id_${random_id}" \
--model_name_or_path $ce_model_path \
--seed $seed \
--mask_t_i False \
--output_dir $scst_output_path \
--num_prefix $i

torchrun \
--nproc_per_node=8 \
./task/captioning/main.py \
--cfg ./config/coco/base_test_cfg.yaml  \
--eval_model_dir $scst_model_path \
--num_prefix $i \
--mask_t_i False \
--freeze_backbone False \
--output_dir $scst_eval_output_path
