ANSWER_MATCH_TEMPLATE="""In this task, there is a math question and its reference answer. An AI model provides a solution to the question. Your job is to check whether the model's solution is correct. In your judgment, please first identify the final answer proposed by the model's solution, then compare it with the reference answer. If the model's answer matches the reference answer, please write "Therefore, the answer is \\boxed{correct}"; otherwise, please write "Therefore, the answer is \\boxed{wrong}".

Note:
1) If it is a multiple-choice question, the model may either provide the option letter or the answer itself. Both are acceptable.
2) If the reference answer is a decimal, then as long as the predicted answer is within 0.1 of the reference answer, it is considered correct. For example, if the reference number is 5.52 and the model predicts 5.6, it is considered correct.
3) You don't need to write extra explanations. Just identify the model's answer and compare it to the reference. You don't need to explain how the model makes mistakes or why the model's reasoning steps are wrong.

Here are two examples:

## Example 1

Math question:
What is the largest factor of 54,321 that is less than 54,321?\nOptions: A ) 6 , B ) 121 , C ) 18107 , D ) 54,320

Reference answer:
c

Model's solution:
We can start by listing all the factors of 54,321. They are 1, 3, 11, 17, 33, 51, 167, and 54,321. Of these, only 3, 11, 17, and 54,321 are less than 54,321. Since 54,321 is not a prime number, we need to find the largest factor that is less than it. We can do this by finding the product of the remaining factors and checking to see if it is less than 54,321. If not, we will know that the largest factor less than 54,321 is 54,321 itself.\n\nThe product of the remaining factors is $3 \\times 11 \\times 17 = 77189$. Since $77189 < 54,321$, the largest factor of 54,321 that is less than 54,321 is $\\boxed{54,320}$. The answer is 54,320.

Your judgment:
The model's answer is 54,320. The reference answer is C ) 18107. Therefore, the answer is \\boxed{wrong}.

## Example 2

Math question:
A ship uses a sonar system to locate underwater objects. Find the wavelength of a 262-Hz wave in water. (Unit: m) Output format required: float

Reference answer:
5.65

Model's solution:
Using the correct formula and given values, we find the wavelength in water for a 262-Hz wave:\n\n\\[\\lambda = \\frac{v}{f} = \\frac{1450}{262} = 5.519 \\text{ m}\\]\n\nRounding to the nearest whole number, the wavelength is $\\boxed{5.52 \\text{ m}}$. The correct answer is 5.52 m.

Your judgment:
The model's answer is 5.52 meters. The reference answer is 5.65. Their difference is larger than 0.1. Therefore, the answer is \\boxed{wrong}.

Now follow the same format to evaluate the model's solution for the given math question and reference answer.

## Task

Math question:
$$QUESTION$$

Reference answer:
$$ANSWER$$

Model's solution:
$$PREDICTION$$

Your judgment:
"""


EXPERT_FEEDBACK_TEMPLATE="""You are an expert tasked with evaluating and providing feedback on an assistant's performance.

---
Here is an example. Please follow the format as the following expert acts.

Task:
Evaluate $\int\int_C (x+y)^2 dx,dy$, where C is the circle defined by $x^2 + y^2 = M$, and M is the birth year of Li Bai.
Output format requirement: Round to three decimal places, using half up rounding rule.

Assistant:
<thought> To solve this problem, let's start by determining Li Bai's birth year. </thought>
<execute> print(wikipedia_search('Li Bai')) </execute>

Observation:
Page: Li Bai
Summary: Li Bai (Chinese: 李白; pinyin: Lǐ Bái, 701–762), also pronounced as Li Bo, courtesy name Taibai (Chinese: 太白), was a Chinese poet, acclaimed from his own time to the present as a brilliant and romantic figure who took traditional poetic forms to new heights.

Expert feedback:
This is GOOD. You have successfully retrieved the birth year of Li Bai from the wiki search result. Next you should try to solve the calculus problem with the information you obtained.

Assistant:
<thought>
From the wiki_search result, we can see that Li Bai was born in 701, thus M = 701.
To evaluate the double integral of $(x+y)^2$ over the region $C$, where $C$ is the circle defined by $x^2 + y^2 = 701$, we should use polar coordinates.
In polar coordinates, $x = r\cos(\theta)$ and $y = r\sin(\theta)$, and the differential area element $dx,dy$ becomes $r,dr,d\theta$.
$\int\int_C (x+y)^2 dx,dy = \int_0^{2\pi}\int_0^{\sqrt{701}} (r\cos(\theta) + r\sin(\theta))^2r,dr,d\theta$
Let's use the SymPy package to calculate this.
</thought>
<execute>
from sympy import symbols, integrate, cos, sin, pi

r, theta = symbols('r theta')

# the integrand
integrand = (r*cos(theta) + r*sin(theta))**2 * r

# perform the double integration
double_integral = integrate(integrate(integrand, (r, 0, 701 ** 0.5)), (theta, 0, 2*pi))
print(double_integral)
</execute>

Observation:
Out[2]: 245700.5*pi

Expert feedback:
This is GOOD. You successfully converted the double integral into a form that can be calculated. Now you can convert the answer to meet the output format requirement.

Assistant:
<thought> Let's round this result to three decimal places using half up rounding rule. </thought>
<execute>
import math
print(round(245700.5*math.pi, 3))
</execute>

Observation:
771890.886

Expert feedback:
This is GOOD. You have got the solution! You can try to submit the solution now.

Assistant:
The answer is <solution> 771890.886 </solution>.

---

$$TRAJECTORY$$


Correct solution (please DO NOT disclose the correct solution to the assistant): $$ANSWER$$


Please provide concise and constructive feedback. Remember, your role is similar to a teacher. Rather than giving away the solution or details about the answer, guide the assistant toward understanding how to arrive at the correct answer. Your feedback should focus on enhancing the assistant's ability to think critically and respond accurately. Now provide your feedback.
Expert feedback:"""