/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.pennchinese;

import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.UTF8EquivalenceFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChineseEscaper
implements Function<List<HasWord>, List<HasWord>> {
    private static final Pattern p2 = Pattern.compile("\\$[a-z]+_\\((.*?)\\|\\|.*?\\)");

    @Override
    public List<HasWord> apply(List<HasWord> arg) {
        ArrayList<HasWord> ans = new ArrayList<HasWord>(arg);
        for (HasWord wd : ans) {
            String w = wd.word();
            Matcher m2 = p2.matcher(w);
            if (m2.find()) {
                w = m2.replaceAll("$1");
            }
            String newW = UTF8EquivalenceFunction.replaceAscii(w);
            wd.setWord(newW);
        }
        return ans;
    }
}

