/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ie.crf.CRFBiasedClassifier;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class TrueCaseAnnotator
implements Annotator {
    private CRFBiasedClassifier trueCaser;
    private Map<String, String> mixedCaseMap = Generics.newHashMap();
    private boolean VERBOSE = true;
    public static final String DEFAULT_MODEL_BIAS = "INIT_UPPER:-0.7,UPPER:-0.7,O:0";

    public TrueCaseAnnotator() {
        this(true);
    }

    public TrueCaseAnnotator(boolean verbose) {
        this(System.getProperty("truecase.model", "edu/stanford/nlp/models/truecase/truecasing.fast.caseless.qn.ser.gz"), System.getProperty("truecase.bias", DEFAULT_MODEL_BIAS), System.getProperty("truecase.mixedcasefile", "edu/stanford/nlp/models/truecase/MixDisambiguation.list"), verbose);
    }

    public TrueCaseAnnotator(String modelLoc, String classBias, String mixedCaseFileName, boolean verbose) {
        this.VERBOSE = verbose;
        Properties props = new Properties();
        props.setProperty("loadClassifier", modelLoc);
        props.setProperty("mixedCaseMapFile", mixedCaseFileName);
        props.setProperty("classBias", classBias);
        this.trueCaser = new CRFBiasedClassifier(props);
        if (modelLoc == null) {
            throw new RuntimeException("Model location not specified for true-case classifier!");
        }
        this.trueCaser.loadClassifierNoExceptions(modelLoc, props);
        if (classBias != null) {
            StringTokenizer biases = new StringTokenizer(classBias, ",");
            while (biases.hasMoreTokens()) {
                StringTokenizer bias = new StringTokenizer(biases.nextToken(), ":");
                String cname = bias.nextToken();
                double w = Double.parseDouble(bias.nextToken());
                this.trueCaser.setBiasWeight(cname, w);
                if (!this.VERBOSE) continue;
                System.err.println("Setting bias for class " + cname + " to " + w);
            }
        }
        this.mixedCaseMap = TrueCaseAnnotator.loadMixedCaseMap(mixedCaseFileName);
    }

    @Override
    public void annotate(Annotation annotation) {
        if (this.VERBOSE) {
            System.err.print("Adding true-case annotation...");
        }
        if (annotation.containsKey(CoreAnnotations.SentencesAnnotation.class)) {
            for (CoreMap sentence : (List)annotation.get(CoreAnnotations.SentencesAnnotation.class)) {
                List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
                List output = this.trueCaser.classifySentence(tokens);
                for (int i = 0; i < tokens.size(); ++i) {
                    String neTag = (String)((CoreLabel)output.get(i)).get(CoreAnnotations.AnswerAnnotation.class);
                    ((CoreLabel)tokens.get(i)).set(CoreAnnotations.TrueCaseAnnotation.class, neTag);
                    this.setTrueCaseText((CoreLabel)tokens.get(i));
                }
            }
        } else {
            throw new RuntimeException("unable to find sentences in: " + annotation);
        }
    }

    private void setTrueCaseText(CoreLabel l) {
        String text;
        String trueCase = l.getString(CoreAnnotations.TrueCaseAnnotation.class);
        String trueCaseText = text = l.word();
        if (trueCase.equals("UPPER")) {
            trueCaseText = text.toUpperCase();
        } else if (trueCase.equals("LOWER")) {
            trueCaseText = text.toLowerCase();
        } else if (trueCase.equals("INIT_UPPER")) {
            trueCaseText = text.substring(0, 1).toUpperCase() + text.substring(1);
        } else if (trueCase.equals("O") && this.mixedCaseMap.containsKey(text)) {
            trueCaseText = this.mixedCaseMap.get(text);
        }
        l.set(CoreAnnotations.TrueCaseTextAnnotation.class, trueCaseText);
    }

    public static Map<String, String> loadMixedCaseMap(String mapFile) {
        Map<String, String> map = Generics.newHashMap();
        try {
            InputStream is = IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(mapFile);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            for (String line : ObjectBank.getLineIterator(br)) {
                String[] els = (line = line.trim()).split("\\s+");
                if (els.length != 2) {
                    throw new RuntimeException("Wrong format: " + mapFile);
                }
                map.put(els[0], els[1]);
            }
            br.close();
            is.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    @Override
    public Set<Annotator.Requirement> requires() {
        return TOKENIZE_SSPLIT_POS_LEMMA;
    }

    @Override
    public Set<Annotator.Requirement> requirementsSatisfied() {
        return Collections.singleton(TRUECASE_REQUIREMENT);
    }
}

