theory question_83_0
imports Main

begin

typedecl entity
typedecl event

consts
  HeatEnergy :: "entity ⇒ bool"
  ThermalEnergy :: "entity ⇒ bool"
  Heat :: "event ⇒ bool"
  ThermalEnergyTransfer :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Object :: "entity ⇒ bool"

(* Explanation 1: heat energy is synonymous with thermal energy. *)
axiomatization where
  explanation_1: "∀x. HeatEnergy x ⟷ ThermalEnergy x"

(* Explanation 2: heat means heat energy. *)
axiomatization where
  explanation_2: "∀e. Heat e ⟷ (∃x. HeatEnergy x ∧ Agent e x)"

(* Explanation 3: heat means the transfer of thermal energy. *)
axiomatization where
  explanation_3: "∀e. Heat e ⟷ ThermalEnergyTransfer e"

theorem hypothesis:
  assumes asm: "ThermalEnergyTransfer e ∧ Agent e x ∧ Patient e y ∧ Object x ∧ Object y"
  (* Hypothesis: The transfer of thermal energy from one object to another is known as heat. *)
  shows "Heat e"
proof -
  {
    assume asm: "ThermalEnergyTransfer e ∧ Agent e x ∧ Patient e y ∧ Object x ∧ Object y"
    have "HeatEnergy x ⟷ ThermalEnergy x" by (rule explanation_1)
    then have "HeatEnergy x ∧ Agent e x ⟹ Heat e" by (rule explanation_3)
    then have "Heat e" using asm by blast
  }
  then show ?thesis using asm by blast
qed

end
