theory question_85_7
imports Main

begin

typedecl entity
typedecl event

consts
  PacinianCorpuscles :: "entity ⇒ bool"
  SpecificTypeOf :: "entity ⇒ entity ⇒ bool"
  PressureReceptor :: "entity"
  ShareAllLocationProperties :: "entity ⇒ entity ⇒ bool"
  MainlyFoundIn :: "entity ⇒ entity ⇒ bool"
  Skin :: "entity"

(* Explanation 1: Pacinian corpuscles are a specific type of pressure receptors. *)
axiomatization where
  explanation_1: "∀x. PacinianCorpuscles x ⟶ SpecificTypeOf x PressureReceptor"

(* Explanation 2: Pacinian corpuscles share all the location properties of pressure receptors. *)
axiomatization where
  explanation_2: "∀x. PacinianCorpuscles x ⟶ ShareAllLocationProperties x PressureReceptor"

(* Explanation 3: Pressure receptors are mainly found in the skin. *)
axiomatization where
  explanation_3: "MainlyFoundIn PressureReceptor Skin"

(* Explanation 4: If an entity shares all the location properties of another entity, then it is mainly found in the same locations as the other entity. *)
axiomatization where
  explanation_4: "∀x y. ShareAllLocationProperties x y ⟶ (∀z. MainlyFoundIn x z ⟷ MainlyFoundIn y z)"

theorem hypothesis:
  assumes asm: "PacinianCorpuscles x"
  (* Hypothesis: Pacinian corpuscles are found mainly in the skin. *)
  shows "MainlyFoundIn x Skin"
proof -
  from asm have "PacinianCorpuscles x" by simp
  then have "SpecificTypeOf x PressureReceptor" using explanation_1 by blast
  then have "ShareAllLocationProperties x PressureReceptor" using explanation_2 by blast
  then have "∀z. MainlyFoundIn x z ⟷ MainlyFoundIn PressureReceptor z" using explanation_4 by blast
  then have "MainlyFoundIn x Skin" using explanation_3 by blast
  show ?thesis using asm by blast
qed

end
