theory question_30_5

imports Main

begin
typedecl entity
typedecl event
consts
  Human :: "entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Skateboard :: "entity ⇒ bool"
  TricksOn :: "entity ⇒ entity ⇒ bool"
  DoingTricksOn :: "event ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  DoingTricks :: "event ⇒ bool"

(* Explanation: If x is tricking on y and e is the event of doing tricks on y, then x is the agent of e. *)
axiomatization where
  explanation: "∀x y e. TricksOn x y ∧ DoingTricksOn e y ∧ Agent e x ⟹ Agent e x"

theorem hypothesis:
  (* Premise: A man is doing tricks on a skateboard. *)
  assumes asm: "Man x ∧ Skateboard y ∧ DoingTricksOn e y ∧ Agent e x"
  (* Hypothesis: A human doing tricks *)
  shows "∃x e. Human x ∧ DoingTricks e ∧ Agent e x"
proof -
  {
    assume "Man x" and "Skateboard y" and "DoingTricksOn e y" and "Agent e x"
    then have "Human x" by (rule explanation, auto)
    then have "Human x ∧ DoingTricks e ∧ Agent e x"
      using ‹DoingTricksOn e y ∧ Agent e x›
      by (rule explanation, auto)
  }
  then show ?thesis by blast
qed

end
