theory question_98_6
imports Main

begin
typedecl entity
typedecl event

consts
  Person :: "entity ⇒ bool"
  Pool :: "entity ⇒ bool"
  Jumping :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Source :: "event ⇒ entity ⇒ bool"
  RecreationalActivity :: "event ⇒ bool"
  Young :: "entity ⇒ bool"
  Goggles :: "entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  Splashing :: "event ⇒ bool"
  Everywhere :: "event ⇒ bool"
  Man :: "entity ⇒ bool"

(* Explanation 1: A person jumping out of a pool is engaged in a recreational activity. *)
axiomatization where
  explanation_1: "∀x y e. Person x ∧ Pool y ∧ Jumping e ∧ Agent e x ∧ Source e y ⟶ RecreationalActivity e"

(* Explanation 2: A man engaged in a recreational activity is likely to be young. *)
axiomatization where
  explanation_2: "∀x. Man x ∧ RecreationalActivity x ⟶ Young x"

theorem hypothesis:
  (* Premise: A young man wearing goggles, is jumping out of a pool, splashing water everywhere. *)
  assumes asm: "Man x ∧ Goggles y ∧ Pool z ∧ Jumping e ∧ Agent e x ∧ Wearing x y ∧ Source e z ∧ Splashing e ∧ Everywhere e"
  (* Hypothesis: Man jumping out of a pool. *)
  shows "∃x y e. Man x ∧ Pool y ∧ Jumping e ∧ Agent e x ∧ Source e y"
proof -
  from asm have "Man x ∧ Goggles y ∧ Pool z ∧ Jumping e ∧ Agent e x ∧ Wearing x y ∧ Source e z" by blast
  from this have "Person x ∧ Pool z ∧ Jumping e ∧ Agent e x ∧ Source e z" using explanation_1 by blast
  then have "Young x" using explanation_2 by blast
  then show ?thesis using asm by blast
qed

end
