class CmdCaliperDataProcessor():
    def __init__(self, tokenizer, device):
        self.tokenizer = tokenizer
        self.device = device

        self.tokenizer.model_max_length = 512

    def collate_fn(self, sentence_list):
        sentence_tokens_list = self.tokenizer(
            sentence_list,
            return_tensors="pt",
            padding="max_length",
            max_length=self.tokenizer.model_max_length,
            truncation=True
        )
        return {k: v.to(self.device) for k, v in sentence_tokens_list.items()}

    def __call__(self, sentence_list):
        return self.collate_fn(sentence_list)
