from dotenv import load_dotenv
from genai import Credentials, Client
from genai.schema import TextGenerationParameters, TextGenerationReturnOptions

ner_prompt = """
Given a sentence, extract the most important named entity from it.

EXAMPLE 1

Sentence: give me the number of movies directed by Sofia Coppola
Named Entity: Sofia Coppola

EXAMPLE 2

Sentence: Who was the lead actor in the movie The Dark Knight?
Named Entity: The Dark Knight

EXAMPLE 3

Sentence: {{sentence}}
Named Entity:"""

def get_bam_response_ner(prompt, model_id):
    load_dotenv()
    credentials = Credentials.from_env()
    parameters = TextGenerationParameters(decoding_method="greedy", max_new_tokens=100, temperature=0.05, stop_sequences=["\n",",","("], include_stop_sequence=False)
    client = Client(credentials=credentials)
    responses = list(
        client.text.generation.create(
            model_id=model_id,
            inputs=[prompt],
            parameters=parameters,
        )
    )
    return responses[0].results[0].generated_text

def get_named_entity(utterance, model_id="mistralai/mistral-7b-instruct-v0-2"):

    prompt = ner_prompt.replace("{{sentence}}", utterance)
    response = get_bam_response_ner(prompt, model_id)
    output = response.strip()
    return output