-- This module will transliterate Kazakh language text per WT:KK TR.
-- Language code: kaz

local export = {}

local tt = {
	["ү"]="ü",['Ү']='Ü',   ["т"]="t",['Т']='T', ["һ"]="h",['Һ']='H', ["р"]="r",['Р']='R',   ["ф"]="f",['Ф']='F',
	["ю"]="yw",['Ю']='Yw', ["ш"]="ş",['Ш']='Ş', ["ь"]="ʹ",['Ь']='ʹ',   ["ъ"]="ʺ",['Ъ']='ʺ', ["н"]="n",['Н']='N', 
	["п"]="p",['П']='P',   ["й"]="y",['Й']='Y', ["л"]="l",['Л']='L',   ["з"]="z",['З']='Z', ["е"]="e",['Е']='E', 
	["г"]="g",['Г']='G',   ["б"]="b",['Б']='B', ["у"]="w",['У']='W',   ["с"]="s",['С']='S', ["х"]="x",['Х']='X',
	["ч"]="ç",['Ч']='Ç', ["щ"]="şş",['Щ']='Şş', ["я"]="ya",['Я']='Ya', ["ы"]="ı",['Ы']='I', ["э"]="e",['Э']='E', 
	["м"]="m",['М']='M',   ["о"]="o",['О']='O', ["и"]="ï",['И']='Ï', ["ё"]="yo",['Ё']='Yo', ["ж"]="j",['Ж']='J',
	["к"]="k",['К']='K',   ["д"]="d",['Д']='D', ["в"]="v",['В']='V', ["ц"]="c",['Ц']='C', ["а"]="a",['А']='A',
	["ң"]="ñ",['Ң']='Ñ',   ["ә"]="ä",['Ә']='Ä', ["э"]="é",['Э']='É', ["ұ"]="u",['Ұ']='U', ["қ"]="q",['Қ']="Q",
	["ғ"]="ğ",['Ғ']='Ğ',   ["і"]="i",['І']='İ', ["ө"]="ö",['Ө']='Ö', ["ӯ"]="u",['Ӯ']='U'
};

function export.tr(text, lang, sc)
	if sc == "Cyrl" then
		return (mw.ustring.gsub(text, '.', tt))
	end
end

return export