#include "parser.ih"

Parser::Parser(int port, string ip, bool init, string parserPath, string parserArgs)
:
    portno(port)
{ //-confidence -tree_likelihood -sentence_likelihood -modelScore
    d_init = init;
    if (!init)
        return;

    while(!portFree(portno))
    {
        ++portno;
        if (portno == port + 50)
        {
            cerr << "Could not start parser on socket port range: " << port << "-" << port + 50 << '\n';
            exit(0);
        }
    }

    string cmd = "java -jar " + parserPath + " " + parserArgs + " -server " + to_string(portno) + " &";
    std::cerr << cmd << '\n';
    //string cmd = "java -jar BerkeleyParser.java -gr enData/ewtwsj.gr -modelScore -server " + to_string(portno) + " &";
    if (system(&cmd[0]) == 1)
    {
        cerr << "Cannot start parser: " << cmd << '\n';
        exit(1);
    }
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0)
        error("ERROR opening socket");
    server = gethostbyname(&ip[0]);
    if (server == NULL) {
        fprintf(stderr,"ERROR, no such host\n");
        exit(0);
    }
    bzero((char *) &serv_addr, sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    bcopy((char *)server->h_addr,
        (char *)&serv_addr.sin_addr.s_addr,
        server->h_length);
    serv_addr.sin_port = htons(portno);
    if (connect(sockfd,(struct sockaddr *) &serv_addr,sizeof(serv_addr)) < 0)
    {
        sleep(1); //TODO make connection after loading data, saves one whole second!
        if (connect(sockfd,(struct sockaddr *) &serv_addr,sizeof(serv_addr)) < 0)
            error("ERROR connecting");
    }
}
