#include "model.ih"

void Model::gen()
{
    d_cands.push_back(vector<string>());
    d_featVals.push_back(vector<double>());
    d_results.push_back(vector<double>());
    d_curCands.clear();

    string curWord = d_origs[d_wordIdx];
    if (!consider() && !(d_config->goldErrDet && d_origs[d_wordIdx] != d_cors[d_wordIdx]))
        return;
    d_featIdx = 0;
   
    // binary feature which indicates if cand == origWord
    addCands(&curWord, &d_config->idxs[(d_config->goldErrDet)?0:1], 1);
    ++d_featIdx;

    // word2vec 
    if (d_config->featGroups[0] && d_w2v.find(&curWord[0]))
    {
        addCands(d_w2v.getCands(), d_w2v.getVals(), d_w2v.getNumCands());
        ++d_featIdx;
        addCands(d_w2v.getCands(), &d_config->idxs[1], d_w2v.getNumCands());
        ++d_featIdx;
    }
    else
        d_featIdx += 2;
    
    //aspell
    if (d_config->featGroups[1] && d_asp.find(curWord))
        addCands(d_asp.getCands(), &d_config->idxs[1], d_asp.getNumCands());
    ++d_featIdx;

    //add words from lookup list
    if (d_config->featGroups[2])
        for (auto const & cand: d_lookup.getLookups(curWord))
            addCands(&cand.first, &cand.second, 1);
    ++d_featIdx;

    // add candidates that fit the regexp "word.*"
    if (d_config->featGroups[3] && curWord.size() > 2)
    {
        pair<size_t, size_t> range = d_dict.getRange(&curWord[0]);
        for (size_t beg = range.first; beg != range.second; ++beg)
        {
            string cand(d_dict.getWord(beg));
            addCands(&cand, &d_config->idxs[1], 1);
        }
    }
    ++d_featIdx;
    
    if (d_config->featGroups[4])
    {
        addNgrams( &d_google);
        d_featIdx += 3;
        addNgrams( &d_twitter);
        d_featIdx += 3;
    }
    else
        d_featIdx += 6;
    
    if (d_config->featGroups[5])
        addDictLookup(curWord);
    d_featIdx += 2;

    if (d_config->featGroups[6])
        for (size_t candIdx = 0; candIdx != d_cands[d_wordIdx].size(); ++candIdx)
            if (match(curWord, d_cands[d_wordIdx][candIdx]))
                d_featVals[d_wordIdx][candIdx * d_config->numFeats + d_featIdx] = 1.0;
    ++d_featIdx;
}

