/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import matetools.is2.data.Parse;
import matetools.is2.data.SentenceData09;
import matetools.is2.io.CONLLReader09;
import matetools.is2.util.Options;
import org.apache.commons.math.stat.inference.TestUtils;

public class EvaluatorTagger {
    public static int TAGGER = 1;
    public static int what = 0;
    public static final String PUNCT = "!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";

    public static void main(String[] args) {
        Options options = new Options(args);
        what = options.tt;
        if (options.eval && options.significant1 == null) {
            Results r = EvaluatorTagger.evaluate(options.goldfile, options.outfile);
        } else if (options.significant1 != null && options.significant2 != null) {
            System.out.println("compare1 " + options.significant1);
            System.out.println("compare2 " + options.significant2);
            System.out.println("gold     " + options.goldfile);
            EvaluatorTagger.check(options.significant1, options.significant2, options.testfile);
            Results r1 = EvaluatorTagger.evaluate(options.goldfile, options.significant1, false);
            System.out.println("fname 1 done ");
            Results r2 = EvaluatorTagger.evaluate(options.goldfile, options.significant2, false);
            double[] s1 = new double[r1.correctHead.size()];
            double[] s2 = new double[r1.correctHead.size()];
            int k = 0;
            while (k < r1.correctHead.size()) {
                s1[k] = r1.correctHead.get(k);
                s2[k] = r2.correctHead.get(k);
                ++k;
            }
            try {
                double p = TestUtils.pairedTTest((double[])s1, (double[])s2);
                System.out.print("significant to " + p);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (options.significant1 != null) {
            Results results = EvaluatorTagger.evaluate(options.goldfile, options.outfile, true);
        }
    }

    private static void check(String s1, String s2, String pos) {
        CONLLReader09 s1reader = new CONLLReader09(s1, -1);
        SentenceData09 s1i = s1reader.getNext();
        CONLLReader09 s2reader = new CONLLReader09(s2, -1);
        SentenceData09 s2i = s2reader.getNext();
        HashMap labchanged = new HashMap();
        int snt = 0;
        while (s1i != null) {
            ++snt;
            int good = 0;
            int wrong = 0;
            int w = 1;
            while (w < s1i.length()) {
                if (s1i.gpos[s1i.heads[w]].equals(pos) && s1i.ppos[s1i.heads[w]].equals(s1i.gpos[s1i.heads[w]]) && s2i.ppos[s2i.heads[w]].equals(s2i.gpos[s2i.heads[w]])) {
                    HashMap<String, Integer> changed = (HashMap<String, Integer>)labchanged.get(s2i.labels[w]);
                    if (changed == null) {
                        changed = new HashMap<String, Integer>();
                        labchanged.put(s2i.labels[w], changed);
                    }
                    if ((!s1i.plabels[w].equals(s1i.labels[w]) || s1i.pheads[w] != s1i.heads[w]) && s2i.plabels[w].equals(s2i.labels[w]) && s2i.pheads[w] == s2i.heads[w]) {
                        ++good;
                        Integer goodL = (Integer)changed.get("G");
                        if (goodL == null) {
                            goodL = 0;
                        }
                        goodL = goodL + 1;
                        changed.put("G", goodL);
                    } else {
                        ++wrong;
                        Integer wrongL = (Integer)changed.get("W");
                        if (wrongL == null) {
                            wrongL = 0;
                        }
                        wrongL = wrongL + 1;
                        changed.put("W", wrongL);
                    }
                }
                ++w;
            }
            if (good != 0 || wrong != 0) {
                System.out.println(String.valueOf(snt) + " changed yes:" + good + " no:" + wrong);
            }
            s1i = s1reader.getNext();
            s2i = s2reader.getNext();
        }
        System.out.println("" + labchanged);
    }

    /*
     * WARNING - void declaration
     */
    public static void evaluateTagger(String act_file, String pred_file, String what) {
        CONLLReader09 goldReader = new CONLLReader09(act_file);
        CONLLReader09 predictedReader = new CONLLReader09();
        predictedReader.startReading(pred_file);
        Hashtable<String, Integer> errors = new Hashtable<String, Integer>();
        Hashtable<String, StringBuffer> words = new Hashtable<String, StringBuffer>();
        int total = 0;
        int numsent = 0;
        int corrT = 0;
        SentenceData09 goldInstance = goldReader.getNext();
        SentenceData09 predInstance = predictedReader.getNext();
        HashMap<Integer, int[]> correctL = new HashMap<Integer, int[]>();
        HashMap<String, int[]> pos = new HashMap<String, int[]>();
        HashMap<Object, int[]> mor = new HashMap<Object, int[]>();
        float correctM = 0.0f;
        float allM = 0.0f;
        while (goldInstance != null) {
            int instanceLength = goldInstance.length();
            if (instanceLength != predInstance.length()) {
                System.out.println("Lengths do not match on sentence " + numsent);
            }
            String[] stringArray = goldInstance.gpos;
            String[] pred = predInstance.ppos;
            String[] goldM = goldInstance.ofeats;
            String[] predM = predInstance.pfeats;
            int i = 1;
            while (i < instanceLength) {
                int[] cwr = (int[])correctL.get(i);
                if (cwr == null) {
                    cwr = new int[2];
                    correctL.put(i, cwr);
                }
                cwr[1] = cwr[1] + 1;
                int[] correctPos = (int[])pos.get(stringArray[i]);
                if (correctPos == null) {
                    correctPos = new int[2];
                    pos.put(stringArray[i], correctPos);
                }
                correctPos[1] = correctPos[1] + 1;
                int[] correctMor = (int[])mor.get(goldM[i]);
                if (correctMor == null) {
                    correctMor = new int[2];
                    mor.put(goldM[i], correctMor);
                }
                if (((String)goldM[i]).equals("_") && predM[i] == null || ((String)goldM[i]).equals(predM[i])) {
                    correctM += 1.0f;
                    correctMor[0] = correctMor[0] + 1;
                }
                allM += 1.0f;
                correctMor[1] = correctMor[1] + 1;
                if (stringArray[i].equals(pred[i])) {
                    ++corrT;
                    cwr[0] = cwr[0] + 1;
                    correctPos[0] = correctPos[0] + 1;
                } else {
                    String key = "gold: '" + stringArray[i] + "' pred: '" + pred[i] + "'";
                    Integer cnt = (Integer)errors.get(key);
                    StringBuffer errWrd = (StringBuffer)words.get(key);
                    if (cnt == null) {
                        errors.put(key, 1);
                        words.put(key, new StringBuffer().append(goldInstance.forms[i]));
                    } else {
                        errors.put(key, cnt + 1);
                        errWrd.append(" " + goldInstance.forms[i]);
                    }
                }
                ++i;
            }
            total += instanceLength - 1;
            ++numsent;
            goldInstance = goldReader.getNext();
            predInstance = predictedReader.getNext();
        }
        ArrayList<Map.Entry> opsl = new ArrayList<Map.Entry>();
        for (Map.Entry entry : errors.entrySet()) {
            opsl.add(entry);
        }
        Collections.sort(opsl, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                return o1.getValue() == o2.getValue() ? 0 : (o1.getValue() > o2.getValue() ? -1 : 1);
            }
        });
        boolean bl = false;
        if (what.contains("top")) {
            System.out.println("top most errors:");
            for (Map.Entry e : opsl) {
                void var18_23;
                ++var18_23;
                if ((Integer)e.getValue() <= 10) continue;
                System.out.println(String.valueOf((String)e.getKey()) + "  " + e.getValue() + " context: " + words.get(e.getKey()));
            }
        }
        if (what.contains("length")) {
            int k = 0;
            while (k < 60) {
                int[] cwr = (int[])correctL.get(k);
                if (cwr != null) {
                    System.out.print(String.valueOf(k) + ":" + cwr[0] + ":" + cwr[1] + ":" + (float)Math.round(10000.0f * (float)cwr[0] / (float)cwr[1]) / 100.0f + " ");
                }
                ++k;
            }
            System.out.println();
        }
        if (what.contains("pos")) {
            for (Map.Entry e : pos.entrySet()) {
                System.out.print(String.valueOf((String)e.getKey()) + ":" + ((int[])e.getValue())[0] + ":" + ((int[])e.getValue())[1] + ":" + (float)Math.round(10000.0f * (float)((int[])e.getValue())[0] / (float)((int[])e.getValue())[1]) / 100.0f + " ");
            }
            System.out.print("");
        }
        System.out.println();
        if (what.contains("mor")) {
            for (Map.Entry e : mor.entrySet()) {
                System.out.print(String.valueOf((String)e.getKey()) + ":" + ((int[])e.getValue())[0] + ":" + ((int[])e.getValue())[1] + ":" + (float)Math.round(10000.0f * (float)((int[])e.getValue())[0] / (float)((int[])e.getValue())[1]) / 100.0f + " ");
            }
            System.out.print("");
        }
        System.out.println("\nTokens: " + total + " Correct: " + corrT + " " + (float)corrT / (float)total + " Correct M.:" + (int)correctM + " morphology " + correctM / (float)total);
    }

    public static int errors(SentenceData09 s, boolean uas) {
        int errors = 0;
        int k = 1;
        while (k < s.length()) {
            if (s.heads[k] != s.pheads[k] && (uas || !s.labels[k].equals(s.plabels[k]))) {
                ++errors;
            }
            ++k;
        }
        return errors;
    }

    public static int errors(SentenceData09 s1, SentenceData09 s2, HashMap<String, Integer> r1, HashMap<String, Integer> r2) {
        int errors = 0;
        int k = 1;
        while (k < s1.length()) {
            Integer cnt;
            if ((s1.heads[k] != s1.pheads[k] || !s1.labels[k].equals(s1.plabels[k])) && s2.heads[k] == s2.pheads[k] && s2.labels[k].equals(s2.plabels[k])) {
                cnt = r1.get(s1.labels[k]);
                if (cnt == null) {
                    cnt = 0;
                }
                cnt = cnt + 1;
                r1.put(s1.labels[k], cnt);
            }
            if ((s2.heads[k] != s2.pheads[k] || !s2.labels[k].equals(s2.plabels[k])) && s1.heads[k] == s1.pheads[k] && s1.labels[k].equals(s1.plabels[k])) {
                cnt = r2.get(s2.labels[k]);
                if (cnt == null) {
                    cnt = 0;
                }
                cnt = cnt + 1;
                r2.put(s2.labels[k], cnt);
            }
            ++k;
        }
        return errors;
    }

    public static Results evaluate(String act_file, String pred_file) {
        return EvaluatorTagger.evaluate(act_file, pred_file, true);
    }

    public static Results evaluate(String act_file, String pred_file, boolean printEval) {
        return EvaluatorTagger.evaluate(act_file, pred_file, printEval, false);
    }

    public static Results evaluate(String act_file, String pred_file, boolean printEval, boolean sig) {
        CONLLReader09 goldReader = new CONLLReader09(act_file, -1);
        CONLLReader09 predictedReader = new CONLLReader09(pred_file, -1);
        int total = 0;
        int corr = 0;
        int corrL = 0;
        int Ptotal = 0;
        int Pcorr = 0;
        int PcorrL = 0;
        int BPtotal = 0;
        int BPcorr = 0;
        int BPcorrL = 0;
        int corrLableAndPos = 0;
        int corrHeadAndPos = 0;
        int corrLableAndPosP = 0;
        int corrHeadAndPosP = 0;
        int corrLableAndPosC = 0;
        int numsent = 0;
        int corrsent = 0;
        int corrsentL = 0;
        int Pcorrsent = 0;
        int PcorrsentL = 0;
        boolean sameProj = false;
        int proj = 0;
        int nonproj = 0;
        int pproj = 0;
        int pnonproj = 0;
        int nonProjOk = 0;
        int nonProjWrong = 0;
        boolean corrOne = false;
        int correctChnWoPunc = 0;
        int correctLChnWoPunc = 0;
        int CPtotal = 0;
        SentenceData09 goldInstance = goldReader.getNext();
        SentenceData09 predInstance = predictedReader.getNext();
        HashMap<String, Integer> label = new HashMap<String, Integer>();
        HashMap<String, Integer> labelCount = new HashMap<String, Integer>();
        HashMap<String, Integer> labelCorrect = new HashMap<String, Integer>();
        HashMap<String, Integer> falsePositive = new HashMap<String, Integer>();
        HashMap<String, HashMap<String, Integer>> confusion = new HashMap<String, HashMap<String, Integer>>();
        HashMap posLabelAssign = new HashMap();
        ArrayList<Double> correctHead = new ArrayList<Double>();
        while (goldInstance != null) {
            String[] predLabels;
            String[] goldLabels;
            int instanceLength = goldInstance.length();
            if (instanceLength != predInstance.length()) {
                System.out.println("Lengths do not match on sentence " + numsent);
            }
            int[] goldHeads = goldInstance.heads;
            if (what == TAGGER) {
                goldLabels = goldInstance.gpos;
                predLabels = predInstance.ppos;
            } else {
                goldLabels = goldInstance.labels;
                predLabels = predInstance.plabels;
            }
            int[] predHeads = predInstance.pheads;
            boolean whole = true;
            boolean wholeL = true;
            boolean Pwhole = true;
            boolean PwholeL = true;
            int tlasS = 0;
            boolean totalS = false;
            int corrLabels = 0;
            boolean XLabels = false;
            int punc = 0;
            int bpunc = 0;
            int totalChnWoPunc = 0;
            int i = 1;
            while (i < instanceLength) {
                Integer num;
                Parse p = new Parse(predHeads.length);
                int k = 0;
                while (k < p.heads.length) {
                    p.heads[k] = (short)predHeads[k];
                    ++k;
                }
                Parse g = new Parse(predHeads.length);
                int k2 = 0;
                while (k2 < g.heads.length) {
                    g.heads[k2] = (short)goldHeads[k2];
                    ++k2;
                }
                HashMap<String, Integer> labelsNum = (HashMap<String, Integer>)posLabelAssign.get(goldInstance.gpos[goldInstance.heads[i]]);
                if (labelsNum == null) {
                    labelsNum = new HashMap<String, Integer>();
                    posLabelAssign.put(goldInstance.gpos[goldInstance.heads[i]], labelsNum);
                }
                if ((num = (Integer)labelsNum.get(goldInstance.labels[i])) == null) {
                    num = 0;
                }
                num = num + 1;
                labelsNum.put(goldInstance.labels[i], num);
                Integer count = (Integer)labelCount.get(goldLabels[i]);
                if (count == null) {
                    count = 0;
                }
                count = count + 1;
                labelCount.put(goldLabels[i], count);
                if (goldLabels[i].equals(predLabels[i]) && (what == TAGGER || predHeads[i] == goldHeads[i])) {
                    Integer correct = (Integer)labelCorrect.get(goldLabels[i]);
                    if (correct == null) {
                        correct = 0;
                    }
                    correct = correct + 1;
                    labelCorrect.put(goldLabels[i], correct);
                } else {
                    Integer fp = (Integer)falsePositive.get(predLabels[i]);
                    if (fp == null) {
                        fp = 0;
                    }
                    fp = fp + 1;
                    falsePositive.put(predLabels[i], fp);
                    HashMap<String, Integer> conf = (HashMap<String, Integer>)confusion.get(goldLabels[i]);
                    if (conf == null) {
                        conf = new HashMap<String, Integer>();
                        confusion.put(goldLabels[i], conf);
                    }
                    conf.put(predLabels[i], conf.get(predLabels[i]) == null ? 1 : (Integer)conf.get(predLabels[i]) + 1);
                }
                boolean tlas = false;
                if (predHeads[i] == goldHeads[i]) {
                    ++corr;
                    if (goldInstance.gpos[i].equals(predInstance.ppos[i])) {
                        ++corrHeadAndPos;
                    }
                    if (goldLabels[i].equals(predLabels[i])) {
                        ++corrL;
                        ++corrLabels;
                        if (goldInstance.gpos[i].equals(predInstance.ppos[i])) {
                            ++tlasS;
                            tlas = true;
                            ++corrLableAndPos;
                        }
                    } else {
                        wholeL = false;
                    }
                } else {
                    whole = false;
                    wholeL = false;
                    count = (Integer)label.get(goldLabels[i]);
                    if (count == null) {
                        count = 0;
                    }
                    count = count + 1;
                    label.put(goldLabels[i], count);
                    int n = Math.abs(goldInstance.heads[i] - i);
                }
                if (!"!\"#$%&''()*+,-./:;<=>?@[\\]^_{|}~``".contains(goldInstance.forms[i])) {
                    if (predHeads[i] == goldHeads[i]) {
                        ++BPcorr;
                        if (goldLabels[i].equals(predLabels[i])) {
                            ++BPcorrL;
                        }
                    }
                } else {
                    ++bpunc;
                }
                if (!",.:''``".contains(goldInstance.forms[i])) {
                    if (predHeads[i] == goldHeads[i]) {
                        if (goldInstance.gpos[i].equals(predInstance.ppos[i])) {
                            ++corrHeadAndPosP;
                        }
                        ++Pcorr;
                        if (goldLabels[i].equals(predLabels[i])) {
                            ++PcorrL;
                            if (goldInstance.gpos[i].equals(predInstance.ppos[i])) {
                                ++corrLableAndPosP;
                            }
                        } else {
                            PwholeL = false;
                        }
                    } else {
                        Pwhole = false;
                        PwholeL = false;
                    }
                } else {
                    ++punc;
                }
                if (!goldInstance.gpos[i].toLowerCase().startsWith("pu")) {
                    if (predHeads[i] == goldHeads[i]) {
                        ++correctChnWoPunc;
                        if (goldLabels[i].equals(predLabels[i])) {
                            ++correctLChnWoPunc;
                            if (goldInstance.gpos[i].equals(predInstance.ppos[i])) {
                                ++corrLableAndPosC;
                            }
                        }
                    }
                } else {
                    ++totalChnWoPunc;
                }
                if (sig) {
                    if (tlas) {
                        System.out.println("1\t");
                    } else {
                        System.out.println("0\t");
                    }
                }
                ++i;
            }
            total += instanceLength - 1;
            Ptotal += instanceLength - 1 - punc;
            BPtotal += instanceLength - 1 - bpunc;
            CPtotal += instanceLength - 1 - totalChnWoPunc;
            if (whole) {
                ++corrsent;
            }
            if (wholeL) {
                ++corrsentL;
            }
            if (Pwhole) {
                ++Pcorrsent;
            }
            if (PwholeL) {
                ++PcorrsentL;
            }
            ++numsent;
            goldInstance = goldReader.getNext();
            predInstance = predictedReader.getNext();
            correctHead.add((double)corrLabels / (double)(instanceLength - 1));
        }
        Results r = new Results();
        r.correctHead = correctHead;
        int mult = 100000;
        int diff = 1000;
        r.total = total;
        r.corr = corr;
        r.las = (float)Math.round((double)corrL / (double)total * (double)mult) / (float)diff;
        r.ula = (float)Math.round((double)corr / (double)total * (double)mult) / (float)diff;
        r.lpas = (float)Math.round((double)corrLableAndPos / (double)total * (double)mult) / (float)diff;
        r.upla = (float)Math.round((double)corrHeadAndPos / (double)total * (double)mult) / (float)diff;
        float tlasp = (float)Math.round((double)corrLableAndPosP / (double)Ptotal * (double)mult) / (float)diff;
        float tlasc = (float)Math.round((double)corrLableAndPosC / (double)Ptotal * (double)mult) / (float)diff;
        System.out.print(" LAS/Total/UAS/Total: " + r.las + "/" + (double)Math.round((double)corrsentL / (double)numsent * (double)mult) / (double)diff + "/" + r.ula + "/" + (double)Math.round((double)corrsent / (double)numsent * (double)mult) / (double)diff + " LPAS/UPAS " + r.lpas + "/" + r.upla);
        System.out.println("; without . " + (double)Math.round((double)PcorrL / (double)Ptotal * (double)mult) / (double)diff + "/" + (double)Math.round((double)PcorrsentL / (double)numsent * (double)mult) / (double)diff + "/" + (double)Math.round((double)Pcorr / (double)Ptotal * (double)mult) / (double)diff + "/" + (double)Math.round((double)Pcorrsent / (double)numsent * (double)mult) / (double)diff + " TLAS " + tlasp + " V2 LAS/UAS " + (double)Math.round((double)BPcorrL / (double)BPtotal * (double)mult) / (double)diff + "/" + (double)Math.round((double)BPcorr / (double)BPtotal * (double)mult) / (double)diff + " CHN LAS/UAS " + (double)Math.round((double)correctLChnWoPunc / (double)CPtotal * (double)mult) / (double)diff + "/" + (double)Math.round((double)correctChnWoPunc / (double)CPtotal * (double)mult) / (double)diff + " TLAS " + tlasc);
        float precisionNonProj = (float)nonProjOk / ((float)nonProjOk + (float)nonProjWrong);
        float recallNonProj = (float)nonProjOk / (float)nonproj;
        System.out.println("proj " + proj + " nonp " + nonproj + "; predicted proj " + pproj + " non " + pnonproj + "; nonp correct " + nonProjOk + " nonp wrong " + nonProjWrong + " precision=(nonProjOk)/(non-projOk+nonProjWrong): " + precisionNonProj + " recall=nonProjOk/nonproj=" + recallNonProj + " F=" + 2.0f * precisionNonProj * recallNonProj / (precisionNonProj + recallNonProj));
        if (!printEval) {
            return r;
        }
        HashMap totalX = new HashMap();
        HashMap totalY = new HashMap();
        String A = " ";
        System.out.println("label\ttp\tcount\trecall\t\ttp\tfp+tp\tprecision\t F-Score ");
        for (Map.Entry e : labelCount.entrySet()) {
            int tp = labelCorrect.get(e.getKey()) == null ? 0 : (Integer)labelCorrect.get(e.getKey());
            Integer count = (Integer)labelCount.get(e.getKey());
            int fp = falsePositive.get(e.getKey()) == null ? 0 : (Integer)falsePositive.get(e.getKey());
            System.out.println(String.valueOf((String)e.getKey()) + "\t" + tp + "\t" + count + "\t" + EvaluatorTagger.roundPercent((float)tp / (float)count.intValue()) + "\t\t" + tp + "\t" + (fp + tp) + "\t" + EvaluatorTagger.roundPercent((float)tp / (float)(fp + tp)) + "\t\t" + EvaluatorTagger.roundPercent((float)tp / (float)count.intValue() + (float)tp / (float)(fp + tp)) / 2.0f);
        }
        for (Map.Entry e : confusion.entrySet()) {
            HashMap values = (HashMap)e.getValue();
            ArrayList entries = new ArrayList(values.entrySet());
            Collections.sort(entries, new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                    return o2.getValue().compareTo(o1.getValue());
                }
            });
            System.out.println(String.valueOf((String)e.getKey()) + "\t" + entries);
        }
        System.out.println("" + posLabelAssign);
        return r;
    }

    public static float round(double v) {
        return (float)Math.round(v * 10000.0) / 10000.0f;
    }

    public static float roundPercent(double v) {
        return (float)Math.round(v * 10000.0) / 100.0f;
    }

    public static class Results {
        public int total;
        public int corr;
        public float las;
        public float ula;
        public float lpas;
        public float upla;
        ArrayList<Double> correctHead;
    }
}

