/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.SegmentTermDocs;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;

public class CheckIndex {
    public static PrintStream out;
    private PrintStream infoStream;
    private Directory dir;
    private static boolean assertsOn;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CheckIndex(Directory dir) {
        this.dir = dir;
        this.infoStream = out;
    }

    public void setInfoStream(PrintStream out) {
        this.infoStream = out;
    }

    private void msg(String msg) {
        if (this.infoStream != null) {
            this.infoStream.println(msg);
        }
    }

    public static boolean check(Directory dir, boolean doFix) throws IOException {
        return CheckIndex.check(dir, doFix, null);
    }

    public static boolean check(Directory dir, boolean doFix, List onlySegments) throws IOException {
        CheckIndex checker = new CheckIndex(dir);
        Status status = checker.checkIndex(onlySegments);
        if (doFix && !status.clean) {
            checker.fixIndex(status);
        }
        return status.clean;
    }

    public Status checkIndex() throws IOException {
        return this.checkIndex(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Status checkIndex(List onlySegments) throws IOException {
        int format;
        String segmentsFileName;
        int numSegments;
        Status result;
        SegmentInfos sis;
        NumberFormat nf;
        block61: {
            nf = NumberFormat.getInstance();
            sis = new SegmentInfos();
            result = new Status();
            result.dir = this.dir;
            try {
                sis.read(this.dir);
            }
            catch (Throwable t) {
                this.msg("ERROR: could not read any segments file in directory");
                result.missingSegments = true;
                if (this.infoStream == null) return result;
                t.printStackTrace(this.infoStream);
                return result;
            }
            numSegments = sis.size();
            segmentsFileName = sis.getCurrentSegmentFileName();
            IndexInput input = null;
            try {
                input = this.dir.openInput(segmentsFileName);
            }
            catch (Throwable t) {
                this.msg("ERROR: could not open segments file in directory");
                if (this.infoStream != null) {
                    t.printStackTrace(this.infoStream);
                }
                result.cantOpenSegments = true;
                return result;
            }
            format = 0;
            try {
                try {
                    format = input.readInt();
                }
                catch (Throwable t) {
                    this.msg("ERROR: could not read segment file version in directory");
                    if (this.infoStream != null) {
                        t.printStackTrace(this.infoStream);
                    }
                    result.missingSegmentVersion = true;
                    Status status = result;
                    Object var12_12 = null;
                    if (input == null) return status;
                    input.close();
                    return status;
                }
                Object var12_11 = null;
                if (input == null) break block61;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (input == null) throw throwable;
                input.close();
                throw throwable;
            }
            input.close();
        }
        String sFormat = "";
        boolean skip = false;
        if (format == -1) {
            sFormat = "FORMAT [Lucene Pre-2.1]";
        }
        if (format == -2) {
            sFormat = "FORMAT_LOCKLESS [Lucene 2.1]";
        } else if (format == -3) {
            sFormat = "FORMAT_SINGLE_NORM_FILE [Lucene 2.2]";
        } else if (format == -4) {
            sFormat = "FORMAT_SHARED_DOC_STORE [Lucene 2.3]";
        } else if (format == -5) {
            sFormat = "FORMAT_CHECKSUM [Lucene 2.4]";
        } else if (format == -6) {
            sFormat = "FORMAT_DEL_COUNT [Lucene 2.4]";
        } else if (format == -7) {
            sFormat = "FORMAT_HAS_PROX [Lucene 2.4]";
        } else if (format < -7) {
            sFormat = "int=" + format + " [newer version of Lucene than this tool]";
            skip = true;
        } else {
            sFormat = format + " [Lucene 1.3 or prior]";
        }
        this.msg("Segments file=" + segmentsFileName + " numSegments=" + numSegments + " version=" + sFormat);
        result.segmentsFileName = segmentsFileName;
        result.numSegments = numSegments;
        result.segmentFormat = sFormat;
        if (onlySegments != null) {
            result.partial = true;
            if (this.infoStream != null) {
                this.infoStream.print("\nChecking only these segments:");
            }
            Iterator it = onlySegments.iterator();
            while (it.hasNext()) {
                if (this.infoStream == null) continue;
                this.infoStream.print(" " + it.next());
            }
            result.segmentsChecked.addAll(onlySegments);
            this.msg(":");
        }
        if (skip) {
            this.msg("\nERROR: this index appears to be created by a newer version of Lucene than this tool was compiled on; please re-compile this tool on the matching version of Lucene; exiting");
            result.toolOutOfDate = true;
            return result;
        }
        result.newSegments = (SegmentInfos)sis.clone();
        result.newSegments.clear();
        for (int i = 0; i < numSegments; ++i) {
            SegmentInfo info;
            block62: {
                Object var40_50;
                info = sis.info(i);
                if (onlySegments != null && !onlySegments.contains(info.name)) continue;
                Status.SegmentInfoStatus segInfoStat = new Status.SegmentInfoStatus();
                result.segmentInfos.add(segInfoStat);
                this.msg("  " + (1 + i) + " of " + numSegments + ": name=" + info.name + " docCount=" + info.docCount);
                segInfoStat.name = info.name;
                segInfoStat.docCount = info.docCount;
                int toLoseDocCount = info.docCount;
                IndexReader reader = null;
                try {
                    try {
                        int numDocs;
                        String delFileName;
                        this.msg("    compound=" + info.getUseCompoundFile());
                        segInfoStat.compound = info.getUseCompoundFile();
                        this.msg("    hasProx=" + info.getHasProx());
                        segInfoStat.hasProx = info.getHasProx();
                        this.msg("    numFiles=" + info.files().size());
                        segInfoStat.numFiles = info.files().size();
                        this.msg("    size (MB)=" + nf.format((double)info.sizeInBytes() / 1048576.0));
                        segInfoStat.sizeMB = (double)info.sizeInBytes() / 1048576.0;
                        int docStoreOffset = info.getDocStoreOffset();
                        if (docStoreOffset != -1) {
                            this.msg("    docStoreOffset=" + docStoreOffset);
                            segInfoStat.docStoreOffset = docStoreOffset;
                            this.msg("    docStoreSegment=" + info.getDocStoreSegment());
                            segInfoStat.docStoreSegment = info.getDocStoreSegment();
                            this.msg("    docStoreIsCompoundFile=" + info.getDocStoreIsCompoundFile());
                            segInfoStat.docStoreCompoundFile = info.getDocStoreIsCompoundFile();
                        }
                        if ((delFileName = info.getDelFileName()) == null) {
                            this.msg("    no deletions");
                            segInfoStat.hasDeletions = false;
                        } else {
                            this.msg("    has deletions [delFileName=" + delFileName + "]");
                            segInfoStat.hasDeletions = true;
                            segInfoStat.deletionsFileName = delFileName;
                        }
                        if (this.infoStream != null) {
                            this.infoStream.print("    test: open reader.........");
                        }
                        reader = SegmentReader.get(info);
                        toLoseDocCount = numDocs = ((SegmentReader)reader).numDocs();
                        if (((SegmentReader)reader).hasDeletions()) {
                            if (info.docCount - numDocs != info.getDelCount()) {
                                throw new RuntimeException("delete count mismatch: info=" + info.getDelCount() + " vs reader=" + (info.docCount - numDocs));
                            }
                            segInfoStat.numDeleted = info.docCount - numDocs;
                            this.msg("OK [" + segInfoStat.numDeleted + " deleted docs]");
                        } else {
                            if (info.getDelCount() != 0) {
                                throw new RuntimeException("delete count mismatch: info=" + info.getDelCount() + " vs reader=" + (info.docCount - numDocs));
                            }
                            this.msg("OK");
                        }
                        if (this.infoStream != null) {
                            this.infoStream.print("    test: fields, norms.......");
                        }
                        Collection fieldNames = ((SegmentReader)reader).getFieldNames(IndexReader.FieldOption.ALL);
                        Iterator it = fieldNames.iterator();
                        while (it.hasNext()) {
                            String fieldName = (String)it.next();
                            byte[] b = ((SegmentReader)reader).norms(fieldName);
                            if (b.length == info.docCount) continue;
                            throw new RuntimeException("norms for field \"" + fieldName + "\" is length " + b.length + " != maxDoc " + info.docCount);
                        }
                        this.msg("OK [" + fieldNames.size() + " fields]");
                        segInfoStat.numFields = fieldNames.size();
                        if (this.infoStream != null) {
                            this.infoStream.print("    test: terms, freq, prox...");
                        }
                        TermEnum termEnum = ((SegmentReader)reader).terms();
                        TermPositions termPositions = ((SegmentReader)reader).termPositions();
                        MySegmentTermDocs myTermDocs = new MySegmentTermDocs((SegmentReader)reader);
                        long termCount = 0L;
                        long totFreq = 0L;
                        long totPos = 0L;
                        while (termEnum.next()) {
                            int delCount;
                            ++termCount;
                            Term term = termEnum.term();
                            int docFreq = termEnum.docFreq();
                            termPositions.seek(term);
                            int lastDoc = -1;
                            int freq0 = 0;
                            totFreq += (long)docFreq;
                            while (termPositions.next()) {
                                ++freq0;
                                int doc = termPositions.doc();
                                int freq = termPositions.freq();
                                if (doc <= lastDoc) {
                                    throw new RuntimeException("term " + term + ": doc " + doc + " <= lastDoc " + lastDoc);
                                }
                                lastDoc = doc;
                                if (freq <= 0) {
                                    throw new RuntimeException("term " + term + ": doc " + doc + ": freq " + freq + " is out of bounds");
                                }
                                int lastPos = -1;
                                totPos += (long)freq;
                                for (int j = 0; j < freq; ++j) {
                                    int pos = termPositions.nextPosition();
                                    if (pos < -1) {
                                        throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + " is out of bounds");
                                    }
                                    if (pos >= lastPos) continue;
                                    throw new RuntimeException("term " + term + ": doc " + doc + ": pos " + pos + " < lastPos " + lastPos);
                                }
                            }
                            if (((SegmentReader)reader).hasDeletions()) {
                                myTermDocs.seek(term);
                                while (myTermDocs.next()) {
                                }
                                delCount = myTermDocs.delCount;
                            } else {
                                delCount = 0;
                            }
                            if (freq0 + delCount == docFreq) continue;
                            throw new RuntimeException("term " + term + " docFreq=" + docFreq + " != num docs seen " + freq0 + " + num docs deleted " + delCount);
                        }
                        this.msg("OK [" + termCount + " terms; " + totFreq + " terms/docs pairs; " + totPos + " tokens]");
                        if (this.infoStream != null) {
                            this.infoStream.print("    test: stored fields.......");
                        }
                        int docCount = 0;
                        long totFields = 0L;
                        for (int j = 0; j < info.docCount; ++j) {
                            if (((SegmentReader)reader).isDeleted(j)) continue;
                            ++docCount;
                            Document doc = reader.document(j);
                            totFields += (long)doc.getFields().size();
                        }
                        if (docCount != ((SegmentReader)reader).numDocs()) {
                            throw new RuntimeException("docCount=" + docCount + " but saw " + docCount + " undeleted docs");
                        }
                        this.msg("OK [" + totFields + " total field count; avg " + nf.format((float)totFields / (float)docCount) + " fields per doc]");
                        if (this.infoStream != null) {
                            this.infoStream.print("    test: term vectors........");
                        }
                        int totVectors = 0;
                        for (int j = 0; j < info.docCount; ++j) {
                            TermFreqVector[] tfv;
                            if (((SegmentReader)reader).isDeleted(j) || (tfv = ((SegmentReader)reader).getTermFreqVectors(j)) == null) continue;
                            totVectors += tfv.length;
                        }
                        this.msg("OK [" + totVectors + " total vector count; avg " + nf.format((float)totVectors / (float)docCount) + " term/freq vector fields per doc]");
                        this.msg("");
                    }
                    catch (Throwable t) {
                        this.msg("FAILED");
                        String comment = "fixIndex() would remove reference to this segment";
                        this.msg("    WARNING: " + comment + "; full exception:");
                        if (this.infoStream != null) {
                            t.printStackTrace(this.infoStream);
                        }
                        this.msg("");
                        result.totLoseDocCount += toLoseDocCount;
                        ++result.numBadSegments;
                        var40_50 = null;
                        if (reader == null) continue;
                        reader.close();
                        continue;
                    }
                    var40_50 = null;
                    if (reader == null) break block62;
                }
                catch (Throwable throwable) {
                    var40_50 = null;
                    if (reader == null) throw throwable;
                    reader.close();
                    throw throwable;
                }
                reader.close();
            }
            result.newSegments.add(info.clone());
        }
        if (0 == result.numBadSegments) {
            result.clean = true;
            this.msg("No problems were detected with this index.\n");
            return result;
        }
        this.msg("WARNING: " + result.numBadSegments + " broken segments (containing " + result.totLoseDocCount + " documents) detected");
        return result;
    }

    public void fixIndex(Status result) throws IOException {
        if (result.partial) {
            throw new IllegalArgumentException("can only fix an index that was fully checked (this status checked a subset of segments)");
        }
        result.newSegments.commit(result.dir);
    }

    private static boolean testAsserts() {
        assertsOn = true;
        return true;
    }

    private static boolean assertsOn() {
        if (!$assertionsDisabled && !CheckIndex.testAsserts()) {
            throw new AssertionError();
        }
        return assertsOn;
    }

    public static void main(String[] args) throws IOException {
        boolean doFix = false;
        ArrayList<String> onlySegments = new ArrayList<String>();
        String indexPath = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-fix")) {
                doFix = true;
                ++i;
                continue;
            }
            if (args[i].equals("-segment")) {
                if (i == args.length - 1) {
                    System.out.println("ERROR: missing name for -segment option");
                    System.exit(1);
                }
                onlySegments.add(args[i + 1]);
                i += 2;
                continue;
            }
            if (indexPath != null) {
                System.out.println("ERROR: unexpected extra argument '" + args[i] + "'");
                System.exit(1);
            }
            indexPath = args[i];
            ++i;
        }
        if (indexPath == null) {
            System.out.println("\nERROR: index path not specified");
            System.out.println("\nUsage: java org.apache.lucene.index.CheckIndex pathToIndex [-fix] [-segment X] [-segment Y]\n\n  -fix: actually write a new segments_N file, removing any problematic segments\n  -segment X: only check the specified segments.  This can be specified multiple\n              times, to check more than one segment, eg '-segment _2 -segment _a'.\n              You can't use this with the -fix option\n\n**WARNING**: -fix should only be used on an emergency basis as it will cause\ndocuments (perhaps many) to be permanently removed from the index.  Always make\na backup copy of your index before running this!  Do not run this tool on an index\nthat is actively being written to.  You have been warned!\n\nRun without -fix, this tool will open the index, report version information\nand report any exceptions it hits and what action it would take if -fix were\nspecified.  With -fix, this tool will remove any segments that have issues and\nwrite a new segments_N file.  This means all documents contained in the affected\nsegments will be removed.\n\nThis tool exits with exit code 1 if the index cannot be opened or has any\ncorruption, else 0.\n");
            System.exit(1);
        }
        if (!CheckIndex.assertsOn()) {
            System.out.println("\nNOTE: testing will be more thorough if you run java with '-ea:org.apache.lucene...', so assertions are enabled");
        }
        if (onlySegments.size() == 0) {
            onlySegments = null;
        } else if (doFix) {
            System.out.println("ERROR: cannot specify both -fix and -segment");
            System.exit(1);
        }
        System.out.println("\nOpening index @ " + indexPath + "\n");
        FSDirectory dir = null;
        try {
            dir = FSDirectory.getDirectory(indexPath);
        }
        catch (Throwable t) {
            System.out.println("ERROR: could not open directory \"" + indexPath + "\"; exiting");
            t.printStackTrace(System.out);
            System.exit(1);
        }
        CheckIndex checker = new CheckIndex(dir);
        checker.setInfoStream(System.out);
        Status result = checker.checkIndex(onlySegments);
        if (!result.clean) {
            if (!doFix) {
                System.out.println("WARNING: would write new segments file, and " + result.totLoseDocCount + " documents would be lost, if -fix were specified\n");
            } else {
                System.out.println("WARNING: " + result.totLoseDocCount + " documents will be lost\n");
                System.out.println("NOTE: will write new segments file in 5 seconds; this will remove " + result.totLoseDocCount + " docs from the index. THIS IS YOUR LAST CHANCE TO CTRL+C!");
                for (int s = 0; s < 5; ++s) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        --s;
                        continue;
                    }
                    System.out.println("  " + (5 - s) + "...");
                }
                System.out.println("Writing...");
                checker.fixIndex(result);
                System.out.println("OK");
                System.out.println("Wrote new segments file \"" + result.newSegments.getCurrentSegmentFileName() + "\"");
            }
        }
        System.out.println("");
        int exitCode = result != null && result.clean ? 0 : 1;
        System.exit(exitCode);
    }

    static {
        $assertionsDisabled = !CheckIndex.class.desiredAssertionStatus();
        out = null;
    }

    private static class MySegmentTermDocs
    extends SegmentTermDocs {
        int delCount;

        MySegmentTermDocs(SegmentReader p) {
            super(p);
        }

        public void seek(Term term) throws IOException {
            super.seek(term);
            this.delCount = 0;
        }

        protected void skippingDoc() throws IOException {
            ++this.delCount;
        }
    }

    public static class Status {
        public boolean clean;
        public boolean missingSegments;
        public boolean cantOpenSegments;
        public boolean missingSegmentVersion;
        public String segmentsFileName;
        public int numSegments;
        public String segmentFormat;
        public List segmentsChecked = new ArrayList();
        public boolean toolOutOfDate;
        public List segmentInfos = new ArrayList();
        public Directory dir;
        SegmentInfos newSegments;
        public int totLoseDocCount;
        public int numBadSegments;
        public boolean partial;

        public static class SegmentInfoStatus {
            public String name;
            public int docCount;
            public boolean compound;
            public int numFiles;
            public double sizeMB;
            public int docStoreOffset = -1;
            public String docStoreSegment;
            public boolean docStoreCompoundFile;
            public boolean hasDeletions;
            public String deletionsFileName;
            public int numDeleted;
            public boolean openReaderPassed;
            int numFields;
            public boolean hasProx;
        }
    }
}

