/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.history;

import java.util.ArrayList;
import java.util.HashMap;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.pool.ObjectPoolList;
import org.maltparser.core.symbol.TableHandler;
import org.maltparser.parser.history.GuideHistory;
import org.maltparser.parser.history.GuideUserHistory;
import org.maltparser.parser.history.HistoryException;
import org.maltparser.parser.history.action.ActionDecision;
import org.maltparser.parser.history.action.ComplexDecisionAction;
import org.maltparser.parser.history.action.GuideDecision;
import org.maltparser.parser.history.action.GuideUserAction;
import org.maltparser.parser.history.container.ActionContainer;
import org.maltparser.parser.history.container.CombinedTableContainer;
import org.maltparser.parser.history.container.TableContainer;
import org.maltparser.parser.history.kbest.KBestList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class History
implements GuideUserHistory,
GuideHistory {
    protected final ObjectPoolList<ComplexDecisionAction> actionPool;
    protected Class<? extends KBestList> kBestListClass = null;
    protected int kBestSize;
    protected String separator = "~";
    protected String decisionSettings;
    protected ArrayList<TableContainer> decisionTables;
    protected ArrayList<TableContainer> actionTables;
    protected HashMap<String, TableHandler> tableHandlers;

    public History(String decisionSettings, String separator, HashMap<String, TableHandler> tableHandlers) throws MaltChainedException {
        this.setTableHandlers(tableHandlers);
        this.setSeparator(separator);
        this.initDecisionSettings(decisionSettings);
        this.actionPool = new ObjectPoolList<ComplexDecisionAction>(){

            @Override
            protected ComplexDecisionAction create() throws MaltChainedException {
                return new ComplexDecisionAction(History.this.getThis());
            }

            @Override
            public void resetObject(ComplexDecisionAction o) throws MaltChainedException {
                o.clear();
            }
        };
        this.clear();
    }

    private History getThis() {
        return this;
    }

    @Override
    public GuideUserAction getEmptyGuideUserAction() throws MaltChainedException {
        return (GuideUserAction)((Object)this.getEmptyActionObject());
    }

    @Override
    public ArrayList<ActionContainer> getActionContainers() {
        ArrayList<ActionContainer> actionContainers = new ArrayList<ActionContainer>();
        for (int i = 0; i < this.actionTables.size(); ++i) {
            actionContainers.add(new ActionContainer(this.actionTables.get(i)));
        }
        return actionContainers;
    }

    @Override
    public ActionContainer[] getActionContainerArray() {
        ActionContainer[] actionContainers = new ActionContainer[this.actionTables.size()];
        for (int i = 0; i < this.actionTables.size(); ++i) {
            actionContainers[i] = new ActionContainer(this.actionTables.get(i));
        }
        return actionContainers;
    }

    @Override
    public void clear() throws MaltChainedException {
        this.actionPool.checkInAll();
    }

    @Override
    public GuideDecision getEmptyGuideDecision() throws MaltChainedException {
        return (GuideDecision)this.getEmptyActionObject();
    }

    @Override
    public int getNumberOfDecisions() {
        return this.decisionTables.size();
    }

    @Override
    public TableHandler getTableHandler(String name) {
        return this.tableHandlers.get(name);
    }

    public Class<? extends KBestList> getKBestListClass() {
        return this.kBestListClass;
    }

    @Override
    public void setKBestListClass(Class<?> kBestListClass) throws MaltChainedException {
        try {
            if (kBestListClass != null) {
                this.kBestListClass = kBestListClass.asSubclass(KBestList.class);
            }
        }
        catch (ClassCastException e) {
            throw new HistoryException("The class '" + kBestListClass.getName() + "' is not a subclass of '" + KBestList.class.getName() + "'. ", e);
        }
    }

    @Override
    public int getKBestSize() {
        return this.kBestSize;
    }

    @Override
    public void setKBestSize(int kBestSize) {
        this.kBestSize = kBestSize;
    }

    public int getNumberOfActions() {
        return this.actionTables.size();
    }

    public ArrayList<TableContainer> getDecisionTables() {
        return this.decisionTables;
    }

    public ArrayList<TableContainer> getActionTables() {
        return this.actionTables;
    }

    public HashMap<String, TableHandler> getTableHandlers() {
        return this.tableHandlers;
    }

    public String getSeparator() {
        return this.separator;
    }

    @Override
    public void setSeparator(String separator) throws MaltChainedException {
        if (separator == null || separator.length() < 1) {
            throw new HistoryException("The class item separator (--guide-classitem_separator) does not have correct value. ");
        }
        this.separator = separator;
    }

    public String getDecisionSettings() {
        return this.decisionSettings;
    }

    public void setDecisionSettings(String decisionSettings) {
        this.decisionSettings = decisionSettings;
    }

    protected void setTableHandlers(HashMap<String, TableHandler> tableHandlers) {
        this.tableHandlers = tableHandlers;
    }

    protected ActionDecision getEmptyActionObject() throws MaltChainedException {
        return this.actionPool.checkOut();
    }

    protected void initDecisionSettings(String decisionSettings) throws MaltChainedException {
        this.decisionTables = new ArrayList();
        this.actionTables = new ArrayList();
        this.decisionSettings = decisionSettings;
        int start = 0;
        int k = 0;
        char prevDecisionSeparator = ' ';
        TableContainer tmp = null;
        StringBuilder sbTableHandler = new StringBuilder();
        StringBuilder sbTable = new StringBuilder();
        int state = 0;
        for (int i = 0; i < decisionSettings.length(); ++i) {
            switch (decisionSettings.charAt(i)) {
                case '.': {
                    if (state != 0) {
                        // empty if block
                    }
                    state = 1;
                    break;
                }
                case '+': {
                    tmp = new TableContainer(this.tableHandlers.get(sbTableHandler.toString()).getSymbolTable(sbTable.toString()), sbTableHandler.toString() + "." + sbTable.toString(), '+');
                    this.actionTables.add(tmp);
                    ++k;
                    sbTableHandler.setLength(0);
                    sbTable.setLength(0);
                    state = 0;
                    break;
                }
                case '#': {
                    state = 2;
                    break;
                }
                case ';': {
                    state = 2;
                    break;
                }
                case ',': {
                    state = 2;
                    break;
                }
                default: {
                    if (state == 0) {
                        sbTableHandler.append(decisionSettings.charAt(i));
                        break;
                    }
                    if (state != 1) break;
                    sbTable.append(decisionSettings.charAt(i));
                }
            }
            if (state != 2 && i != decisionSettings.length() - 1) continue;
            char decisionSeparator = decisionSettings.charAt(i);
            if (i == decisionSettings.length() - 1) {
                decisionSeparator = prevDecisionSeparator;
            }
            tmp = new TableContainer(this.tableHandlers.get(sbTableHandler.toString()).getSymbolTable(sbTable.toString()), sbTableHandler.toString() + "." + sbTable.toString(), decisionSeparator);
            this.actionTables.add(tmp);
            if (++k - start > 1) {
                this.decisionTables.add(new CombinedTableContainer(this.getTableHandler("A"), this.separator, this.actionTables.subList(start, k), decisionSeparator));
            } else {
                this.decisionTables.add(tmp);
            }
            sbTableHandler.setLength(0);
            sbTable.setLength(0);
            state = 0;
            start = k;
            prevDecisionSeparator = decisionSeparator;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }
}

