/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.planar3T;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.Function;
import org.maltparser.parser.AbstractParserFactory;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.algorithm.planar3T.Planar3TAddressFunction;
import org.maltparser.parser.algorithm.planar3T.Planar3TConfig;

public abstract class Planar3TFactory
implements AbstractParserFactory {
    protected Algorithm algorithm;
    protected DependencyParserConfig manager;

    public Planar3TFactory(Algorithm algorithm) {
        this.setAlgorithm(algorithm);
        this.setManager(algorithm.getManager());
    }

    public ParserConfiguration makeParserConfiguration() throws MaltChainedException {
        if (this.manager.getConfigLogger().isInfoEnabled()) {
            this.manager.getConfigLogger().info("  Parser configuration : Planar 3T with no_covered_roots = " + this.manager.getOptionValue("planar3t", "no_covered_roots").toString().toUpperCase() + ", " + "acyclicity = " + this.manager.getOptionValue("planar3t", "acyclicity").toString().toUpperCase() + ", connectedness = " + this.manager.getOptionValue("planar3t", "connectedness").toString().toUpperCase() + ", " + "root handling = " + this.manager.getOptionValue("planar3t", "planar_root_handling").toString().toUpperCase() + "\n");
        }
        return new Planar3TConfig(this.manager.getSymbolTables(), this.manager.getOptionValue("planar3t", "no_covered_roots").toString(), this.manager.getOptionValue("planar3t", "acyclicity").toString(), this.manager.getOptionValue("planar3t", "connectedness").toString(), this.manager.getOptionValue("planar3t", "planar_root_handling").toString());
    }

    public Function makeFunction(String subFunctionName) throws MaltChainedException {
        return new Planar3TAddressFunction(subFunctionName, this.algorithm);
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public DependencyParserConfig getManager() {
        return this.manager;
    }

    public void setManager(DependencyParserConfig manager) {
        this.manager = manager;
    }
}

