
<a name="readme-top"></a>

<!-- ABOUT THE PROJECT -->
### About The Project

Through this project, the phenomenon of Hinglish i.e. code mixed Hindi and English, prevalent in informal online communication is explored, by focusing on pun generation. An algorithm to identify homophones from different languages and a lightweight transliteration module from Devanagari to Latin script are proposed. An existing pun generation pipeline in English and the applicability of such pipelines in code mixed settings is analysed. Finally, Large Language Models (LLMs), particularly GPT-3.5's ability to generate puns is assessed and through varioius prompting strategies their limitations are identified and a hybrid approach for generating puns in code-mixed settings using LLMs are suggested. Crowd-sourced evaluations validate the proposed pipeline.


### Installation


1. Clone the repo
   ```sh
   $ git clone https://github.com/github_username/repo_name.git
   ```
2. Create a virtual environment
   ```sh
   $ python3 -m venv .venv
   $ source .venv/bin/activate
   ```
3. Install requirements.txt
   ```sh
   $ pip install -r requirements.txt
   ```
4. Create a .env folder and Save your OPENAI API locally as
   ```sh
   OPENAPI_KEY="my_open_ai_key"
   ```
5. Install some additional nltk packages by opening the python interpretor
   ```sh
   $ python3
   >>> import nltk
   >>> nltk.download('brown')
   >>> nltk.download('averaged_perceptron_tagger')
   ```
6. Install flite to be able to use the epitran English IPA transcription
   ```sh
   $ git clone git@github.com:festvox/flite.git
   $ cd flite/
   $ ./configure && make
   $ sudo make install
   $ cd testsuite
   $ make lex_lookup
   $ sudo cp lex_lookup /usr/local/bin
   ```


<p align="right">(<a href="#readme-top">back to top</a>)</p>

<!-- USAGE EXAMPLES -->
### Usage

This section details the various command-line arguments you can use to customize the program's behavior:

**Required Arguments:**

* **None:** By default, running `main.py` will print a bunch of puns generated by passing some generated Homophones along with 

**Optional Arguments:**

* `-method (str, default='homophone_prompt')`: Selects the method for prompting the large language model (LLM). Choose from:
    * `homophone_prompt`: Uses homophone-based prompting (default) based on the prompts in `prompts/input_homophone` folder - Best Results
    * `prompt` : Uses a wide array of prompts found in the `prompts/algorithmic' folder
    * `homophone` : Generate homophones and try and generate puns by modifying the brown corpus English sentences

* `-llm_model (str, default='gpt-3.5-turbo')`: Selects the OpenAI LLM model to use for chat completion. Defaults to `gpt-3.5-turbo`.
* `-llm_temp (float, default=0.3)`: Controls the randomness of text generation by the LLM. A higher temperature increases randomness. Defaults to 0.3.

**Flags (Boolean Arguments):**

* `-load_homophone (bool)`: If set to `True`, generates homophones from scratch (default: `False`). This is likely only needed when the homophone file (`homophone.csv`) doesn't exist or needs to be recreated.
* `-eval_transliterate (bool)`: If set to `True`, evaluates the transliteration method on the specified dataset (default: `False`).
* `-save_trans_file (str, default='trans_eval.csv')`: Specifies the file name for saving transliteration evaluation results (if `-eval_transliterate` is enabled). Defaults to `trans_eval.csv`.
* `-trans_file_name (str, default='aligned_dataset.tsv')`: Sets the name of the dataset corpus file (in TSV format) for transliteration evaluation. Currently configured for Google Research's Dakshina corpus.
* `-plot_survey (bool)`: If set to `True`, create plots of all the results collected in the survey stored in `data/survey` folder

**Example Usage: Generating Puns**

```sh
python main.py -method homophone_prompt
```
The puns generated in case of prompting are stored in the `prompts/../results` folder
Additionaly they also get printed to the terminal

**Example Usage: Evaluating Transliteration**

```sh
python main.py -eval_transliterate -save_trans_file 'path_to_results'
```
The evalaution accuracy is printed to the terminal, and the transliteration results are saved to the given file

**Example Usage: Generating Graphs

```sh
python main.py -plot_survey
```
The resulting graph images get stored in the `data/survey` folder

<!-- LICENSE -->
## License

Distributed under the MIT License. See `LICENSE.txt` for more information.

<p align="right">(<a href="#readme-top">back to top</a>)</p>

<!-- ACKNOWLEDGMENTS -->
## Acknowledgments
* [Hindi Common Words Source](https://github.com/orgtre/top-open-subtitles-sentences/tree/main)
* [English Common Words Source](https://github.com/first20hours/google-10000-english)
* [Transliteration Character Translation Files](https://huggingface.co/datasets/ai4bharat/Aksharantar/blob/main/hin.zip)
* [Transliteration Evaluation on the Google Dakshina Dataset](https://github.com/google-research-datasets/dakshina)

<p align="right">(<a href="#readme-top">back to top</a>)</p>
