#!/bin/bash
#SBATCH --job-name=superglue # create a short name for your job
#SBATCH -p llm
#SBATCH -N 1 # node count
#SBATCH --ntasks-per-node 1 # number of tasks to run per node
#SBATCH --cpus-per-task 10 # cpu-cores per task (>1 if multi-threaded tasks),--cpus-per-task
#SBATCH --gpus-per-node 1 # total gpus for job

OUTPUT_PREFIX=inference_output
RUN=lora-flan-t5-base

python3 lorahub_inference.py \
    --seed 42 \
    --do_eval \
    --predict_with_generate \
    --bf16 \
    --dataset_name data/flanv2_1121 \
    --model_name_or_path hf_models/flan-t5-base \
    --lora_path hf_models/lorahubs \
    --per_device_eval_batch_size 128 \
    --gradient_accumulation_steps 1 \
    --preprocessing_num_workers 16 \
    --generation_max_length 512 \
    --logging_strategy steps \
    --logging_steps 10 \
    --evaluation_strategy 'epoch' \
    --max_seq_length 768 \
    --max_answer_length 512 \
    --val_max_answer_length 512 \
    --save_total_limit 5 \
    --input_column inputs \
    --output_column targets \
    --temperature 8 \
    --loss_beta 0.1 \
    --lora_rank 16 \
    --lora_alpha 8 \
    --lora_target_modules "['q', 'v']" \
    --lora_dropout 0.05 \
    --report_to wandb \
    --run_name ${OUTPUT_PREFIX}_${RUN} \
    --output_dir output/$OUTPUT_PREFIX/lorahub/$RUN
