theory question_80_0

imports Main

begin

typedecl entity

consts
  Insulator :: "entity ⇒ bool"
  Conductor :: "entity ⇒ bool"
  Rubber :: "entity ⇒ bool"
  ElectricalInsulator :: "event ⇒ bool"
  ThermalInsulator :: "event ⇒ bool"
  Insulates :: "event ⇒ entity ⇒ bool"
  ElectricalEnergy :: "entity ⇒ bool"
  Wood :: "entity ⇒ bool"
  Plastic :: "entity ⇒ bool"
  ElectricalConductor :: "event ⇒ bool"
  Conducts :: "event ⇒ entity ⇒ bool"
  Material :: "entity ⇒ bool"
  Copper :: "entity ⇒ bool"
  Electricity :: "entity ⇒ bool"
  ThermalEnergy :: "entity ⇒ bool"

(* Explanation 1: an insulator is the opposite of a conductor. *)
axiomatization where
  explanation_1: "∀x. Insulator x ⟷ ¬Conductor x"

(* Explanation 2: rubber is an electrical insulator; insulates electrical energy; thermal insulator; insulates thermal energy. *)
axiomatization where
  explanation_2: "∀x. Rubber x ⟶ (∃e. ElectricalInsulator e ∧ Agent e x) ∧ (∃e. Insulates e ∧ Agent e x ∧ Patient e ElectricalEnergy) ∧ (∃e. ThermalInsulator e ∧ Agent e x) ∧ (∃e. Insulates e ∧ Agent e x ∧ Patient e ThermalEnergy)"

(* Explanation 3: wood is an electrical insulator; insulates electrical energy; thermal insulator; insulates thermal energy. *)
axiomatization where
  explanation_3: "∀x. Wood x ⟶ (∃e. ElectricalInsulator e ∧ Agent e x) ∧ (∃e. Insulates e ∧ Agent e x ∧ Patient e ElectricalEnergy) ∧ (∃e. ThermalInsulator e ∧ Agent e x) ∧ (∃e. Insulates e ∧ Agent e x ∧ Patient e ThermalEnergy)"

(* Explanation 4: plastic is usually an electrical insulator; insulates electrical energy. *)
axiomatization where
  explanation_4: "∀x. Plastic x ⟶ (∃e. ElectricalInsulator e ∧ Agent e x) ∧ (∃e. Insulates e ∧ Agent e x ∧ Patient e ElectricalEnergy)"

(* Explanation 5: metal is an electrical conductor; conducts electrical energy. *)
axiomatization where
  explanation_5: "∀x. Metal x ⟶ (∃e. ElectricalConductor e ∧ Agent e x) ∧ (∃e. Conducts e ∧ Agent e x ∧ Patient e ElectricalEnergy)"

(* Explanation 6: metal is a kind of material. *)
axiomatization where
  explanation_6: "∀x. Metal x ⟶ Material x"

(* Explanation 7: copper is a kind of metal. *)
axiomatization where
  explanation_7: "∀x. Copper x ⟶ Metal x"

(* Explanation 8: electricity means electrical energy. *)
axiomatization where
  explanation_8: "∀x. Electricity x ⟷ ElectricalEnergy x"

theorem hypothesis:
  (* Premise: Some materials are electrical conductors. *)
  assumes asm: "Material x ∧ ElectricalConductor x"
  (* Hypothesis: Copper is the material that conducts electricity. *)
  shows "∃x. Copper x ∧  Electricity y ∧ Conducts e ∧ Agent e x ∧ Patient e y "
proof -
  from asm have mat: "Material x" by simp
  have "ElectricalConductor x" by simp
  then have "Metal x" by (rule explanation_5)
  then have "Copper x" by (rule explanation_7)
  have "ElectricalEnergy y" by (rule explanation_8)
  have "Conducts e" by (rule explanation_5)
  show "∃x. Copper x ∧  Electricity y ∧ Conducts e ∧ Agent e x ∧ Patient e y " using mat by simp
qed

end
