theory question_21_6

imports Main

begin

typedecl entity

consts
  Endothermic :: "entity ⇒ bool"
  Tetrapod :: "entity ⇒ bool"
  Vertebrate :: "entity ⇒ bool"
  Aves :: "entity ⇒ bool"
  Bird :: "entity ⇒ bool"

(* Explanation 1: Endothermic tetrapod vertebrates that belong to Class Aves are birds. *)
axiomatization where
  explanation_1: "∀x. Endothermic x ∧ Tetrapod x ∧ Vertebrate x ∧ Aves x ⟶ Bird x"
  
(* Explanation 2: Birds are endothermic tetrapod vertebrates that belong to the official taxonomic classification for birds, which is Class Aves. *)
axiomatization where
  explanation_2: "∀x. Bird x ⟶ (Endothermic x ∧ Tetrapod x ∧ Vertebrate x ∧ Aves x)"
  
(* Explanation 3: Any entity that is an endothermic tetrapod vertebrate and belongs to Class Aves is also classified as an animal in the class Aves (i.e., Aves x). *)
axiomatization where
  explanation_3: "∀x. (Endothermic x ∧ Tetrapod x ∧ Vertebrate x ∧ Aves x) ⟶ Aves x"

theorem hypothesis:
  assumes asm: "Endothermic x ∧ Tetrapod x ∧ Vertebrate x"
  (* Hypothesis: An endothermic tetrapod vertebrate would be animals in the class aves. *)
  shows "Aves x"
proof -
  from asm have "Endothermic x" by simp
  from asm have "Tetrapod x" by simp
  from asm have "Vertebrate x" by simp
  from asm have "Aves x" by simp
  show "Aves x" by simp
qed

end
