theory question_40_2

imports Main

begin

typedecl entity
typedecl event

consts
  YoungBoy :: "entity ⇒ bool"
  Person :: "entity ⇒ bool"
  PlayingInWater :: "entity ⇒ event ⇒ bool"
  Wet :: "entity ⇒ event ⇒ bool"

(* Explanation 1: A young boy is a type of person. *)
axiomatization where
  explanation_1: "∀x. YoungBoy x ⟶ Person x"

(* Explanation 2: Playing in water implies getting wet for any person. *)
axiomatization where
  explanation_2: "∀x e. Person x ∧ PlayingInWater x e ⟶ Wet x e"

(* Explanation 3: A young boy playing in water implies the person (who is the young boy) is getting wet. *)
axiomatization where
  explanation_3: "∀x e. YoungBoy x ∧ PlayingInWater x e ⟶ Wet x e"

theorem hypothesis:
  (* Premise: A young boy playing in a bubble playing in water. *)
  assumes asm: "YoungBoy x ∧ Playing x  e  ∧ PlayingInWater x  e  ∧ Bubble e "
  (* Hypothesis: A person is getting wet. *)
  shows "∃x. Person x ∧ Wet x e"
proof -
  from asm have "PlayingInWater x e" by blast
  then have "Wet x e" using explanation_2 by blast
  then have "Person x ∧ Wet x e" using asm explanation_1 by blast
  then show ?thesis by blast
qed

end
