theory question_18_2
imports Main

begin

typedecl entity
typedecl event

consts
  JavelinCompetition :: "entity ⇒ bool"
  Competition :: "entity ⇒ bool"
  Occurrence :: "event ⇒ bool"

(* Explanation 1: A javelin competition is a kind of competition. *)
axiomatization where
  explanation_1: "∀x. JavelinCompetition x ⟶ Competition x"

(* Explanation 2: The occurrence of a javelin competition entails the existence of a competition. *)
axiomatization where
  explanation_2: "∀x. JavelinCompetition x ⟶ (∃e. Competition e)"

(* Explanation 3: Add a new axiom: "A javelin competition taking place implies that there is a javelin competition." *)
axiomatization where
  added_axiom: "∀x. Occurrence x ⟶ (∃e. JavelinCompetition e)"

(* Explanation 4: Modify the axiom: "A javelin competition taking place implies the existence of a competition." *)
axiomatization where
  modified_axiom: "∀x. JavelinCompetition x ⟶ (∃e. Competition e)"

theorem hypothesis:
  (* Premise: Javelin competition (j) *)
  assumes asm: "JavelinCompetition j"
  (* Hypothesis: There is a competition. *)
  shows "∃e. Competition e"
proof -
  have "∃e. JavelinCompetition e" using asm by simp
  then have "∃e. Competition e" using explanation_2 by blast
  then show ?thesis by blast
qed

end
