theory question_81_6
imports Main
begin

typedecl entity
typedecl event

consts
  Soil :: "entity ⇒ bool"
  Nonliving :: "entity ⇒ bool"
  ComponentOf :: "entity ⇒ entity ⇒ bool"
  Environment :: "entity ⇒ bool"
  Forest :: "entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Soil is a nonliving entity. *)
axiomatization where
  explanation_1: "∀x. Soil x ⟶ Nonliving x"

(* Explanation 2: Soil is typically a nonliving component of environments, such as forests. *)
axiomatization where
  explanation_2: "∀x. Soil x ⟶ Nonliving x ∧ ComponentOf x Environment ∧ (∀y. Forest y ⟶ PartOf x y)"

theorem hypothesis:
  assumes asm: "Soil x"
  (* Hypothesis: Soil is a nonliving part of a forest. *)
  shows "∃x y. Soil x ∧ Nonliving x ∧ Forest y ∧ PartOf x y"
proof -
  from asm have "Soil x" by simp
  then have "Nonliving x" using explanation_1 by blast
  then have "Forest y ∧ PartOf x y" using explanation_2 by blast
  have conclusion: "Nonliving x ∧ Forest y ∧ PartOf x y" using `Nonliving x` `Forest y ∧ PartOf x y` by blast
  show ?thesis using asm conclusion by blast
qed

end
